% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{BrierScaled}
\alias{BrierScaled}
\title{Brier scaled}
\usage{
BrierScaled(probabilities, truth, negative, positive)
}
\arguments{
\item{probabilities}{[numeric] vector of predicted probabilities}

\item{truth}{vector of true values}

\item{negative}{negative class}

\item{positive}{positive class}
}
\description{
Brier score scaled to [0,1], see http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3575184/.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
negative = 0
BrierScaled(probabilities, truth, negative, positive)
}
