% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memgoodness.R
\name{memgoodness}
\alias{memgoodness}
\title{Goodness of fit of the mem}
\usage{
memgoodness(i.data, i.seasons = 10, i.type.threshold = 5,
  i.level.threshold = 0.95, i.tails.threshold = 1, i.type.intensity = 6,
  i.level.intensity = c(0.4, 0.9, 0.975), i.tails.intensity = 1,
  i.type.curve = 2, i.level.curve = 0.95, i.type.other = 2,
  i.level.other = 0.95, i.method = 2, i.param = 2.8, i.n.max = -1,
  i.type.boot = "norm", i.iter.boot = 10000,
  i.calculation.method = "default", i.goodness.method = "cross",
  i.detection.values = seq(2, 3, 0.1), i.weeks.above = 1, i.output = ".",
  i.graph = F, i.prefix = "", i.min.seasons = 6)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.seasons}{Maximum number of seasons to use.}

\item{i.type.threshold}{Type of confidence interval to calculate the threshold.}

\item{i.level.threshold}{Level of confidence interval to calculate the threshold.}

\item{i.tails.threshold}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.intensity}{Type of confidence interval to calculate the intensity thresholds.}

\item{i.level.intensity}{Levels of confidence interval to calculate the intensity thresholds.}

\item{i.tails.intensity}{Tails for the confidence interval to calculate the threshold.}

\item{i.type.curve}{Type of confidence interval to calculate the modelled curve.}

\item{i.level.curve}{Level of confidence interval to calculate the modelled curve.}

\item{i.type.other}{Type of confidence interval to calculate length, start and percentages.}

\item{i.level.other}{Level of confidence interval to calculate length, start and percentages.}

\item{i.method}{Method to calculate the optimal timing of the epidemic.}

\item{i.param}{Parameter to calculate the optimal timing of the epidemic.}

\item{i.n.max}{Number of pre-epidemic values used to calculate the threshold.}

\item{i.type.boot}{Type of bootstrap technique.}

\item{i.iter.boot}{Number of bootstrap iterations.}

\item{i.calculation.method}{method of determining true/false positives and true/false negatives.}

\item{i.goodness.method}{method to calculate goodness.}

\item{i.detection.values}{values to use in the i.param value of \code{memtiming}.}

\item{i.weeks.above}{number of weeks over the threshold to give the alert.}

\item{i.output}{output directory for graphs.}

\item{i.graph}{whether the graphs must be written or not.}

\item{i.prefix}{prefix used for naming graphs.}

\item{i.min.seasons}{minimum number of seasons to perform goodness, default=6.}
}
\value{
\code{memgoodness} returns a list.
A list containing at least the following components:
  \item{validity.data}{data for each value analysed.}
  \item{results}{Total weeks, non-missing weeks, true positives, false positives
true negatives, false negatives, sensitivity, specificity .}
  \item{peaks}{distribution of the levels of intensity of the peaks.}
  \item{peaks.data}{Peak value, week of the peak value, epidemic and intensity thresholds and intensity level of each season analysed.}
}
\description{
Function \code{memgoodness} perform the goodness of fit of the mem
}
\details{
To be written
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Goodness of fit
epi.good<-memgoodness(flucyl,i.detection.values=seq(2.5,2.8,0.1))
epi.good$results
epi.good$peaks

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
