% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{calculate_dispersal_kernel}
\alias{calculate_dispersal_kernel}
\title{Calculate 2D dispersal kernel.}
\usage{
calculate_dispersal_kernel(max_dispersal_dist, kfun, normalize = TRUE, ...)
}
\arguments{
\item{max_dispersal_dist}{\verb{<numeric>} maximum dispersal distance.}

\item{kfun}{\verb{<function>} the kernel function to use. Can be user-defined,
in which case it needs to vectorized and accept (at least) the parameter
"x" representing the distance from the source as its input and return a
vector of the same size as \code{max_dispersal_dist}.}

\item{normalize}{\verb{<boolean>} whether to normalize the kernel.}

\item{...}{additional parameters to be passed to the kernel function.}
}
\value{
Dispersal kernel with probabilities.
}
\description{
Use a user defined function to create a 2D dispersal kernel.
}
\examples{
# a very simple uniform kernel
uniform_kernel <- calculate_dispersal_kernel(
    max_dispersal_dist = 3,
    kfun = function(x) {
        x * 0 + 1
    }
)
# same as
stopifnot(
    uniform_kernel == matrix(1 / 49, nrow = 7, ncol = 7)
)

# now a negative exponential kernel
# not that `mean_dispersal_dist`
# is passed to the kernel function.
calculate_dispersal_kernel(
    max_dispersal_dist = 3,
    kfun = negative_exponential_function,
    mean_dispersal_dist = 1
)
}
