% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_detectAllPoints.R
\name{figure_detectAllPoints}
\alias{figure_detectAllPoints}
\title{Automated detection of plotted points from a scatter-plot figure image.}
\usage{
figure_detectAllPoints(
  aBinaryPlot,
  sensitivity = 0.2,
  point_shape = "circle",
  point_size = 5
)
}
\arguments{
\item{aBinaryPlot}{A binary figure image (an EBImage object).
See: \code{figure_transformToBinary}}

\item{sensitivity}{A value designating the sensitivity of identifying unique
points that overlap.  A smaller number results in a higher sensitivity to 
split overlapping points; a larger number will extract only a single point
from a cluster of overlapping points.}

\item{point_shape}{The shape of points on figure: can be \code{"circle"},
\code{"square"}, or \code{"diamond"}.  If these options do not fit the
shape found in a figure, use the option that best approximates that
shape.}

\item{point_size}{An integer used to designate the size of the points on
the figure.  Close alignment to the size of the points on a figure will
improve point detection.  See \code{EBImage} to help determine which
size to use.}
}
\value{
An \code{EBImage} object with detected scatter-plot points.
}
\description{
Attempts to detect all points of a certain shape and size from a scatter-plot 
figure image (even those lying outside of the axis range).
}
\seealso{
\code{\link{figure_detectAxis}}
}
