% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{densplot_data_frame}
\alias{densplot_data_frame}
\title{Density Function for Data Frame}
\usage{
densplot_data_frame(x, xvar, groups = NULL, facets = NULL, xlab = NULL,
  ref = NULL, log = FALSE, aspect = 1, scales = NULL, panel = NULL,
  auto.key = NULL, keycols = NULL, main = getOption("metaplot_main",
  NULL), sub = getOption("metaplot_sub", NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{xvar}{variable to plot}

\item{groups}{optional grouping variable}

\item{facets}{optional conditioning variables}

\item{xlab}{x axis label}

\item{ref}{optional numeric}

\item{log}{whether to use log scale}

\item{aspect}{passed to \code{\link[lattice]{densityplot}}}

\item{scales}{passed to \code{\link[lattice]{densityplot}}}

\item{panel}{passed to \code{\link[lattice]{densityplot}}}

\item{auto.key}{passed to \code{\link[lattice]{densityplot}}}

\item{keycols}{number of auto.key columns}

\item{main}{character, or a function of x, xvar, groups, facets, and log}

\item{sub}{character, or a function of x, xvar, groups, facets, and log}

\item{...}{passed to \code{\link[lattice]{densityplot}}}
}
\description{
Plot density for object of class 'data.frame' using standard evaluation.
}
\examples{
densplot_data_frame(Theoph, 'conc', grid = TRUE)
densplot_data_frame(Theoph, 'conc', 'Subject')
densplot_data_frame(Theoph, 'conc', , 'Subject')
}
\seealso{
Other univariate plots: \code{\link{densplot.data.frame}},
  \code{\link{densplot}}, \code{\link{metaplot.data.frame}}

Other densplot: \code{\link{densplot.data.frame}},
  \code{\link{densplot}}
}
