% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{meta_geo}
\alias{meta_geo}
\title{Geotagging Metadata Tags}
\usage{
meta_geo(
  .meta = meta(),
  icbm = NULL,
  geo_position = NULL,
  geo_region = NULL,
  geo_placename = NULL,
  ...
)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{icbm}{Latitude and longitude of geographic positions specified as
\code{"lat, long"}. Can optionally be a length-two vector, i.e. \code{c(lat, long)}.}

\item{geo_position}{Latitude and longitude of geographic positions specified
as \code{"lat;long"}. Can optionally be a length-two vector, i.e. \code{c(lat, long)}.}

\item{geo_region}{Name of the geographic region related to the page content,
specified using \href{https://en.wikipedia.org/wiki/ISO_3166}{ISO-3166}
2-character country code and 2-character national subdivision. Example:
\code{"US-NY"}.}

\item{geo_placename}{Name of the geographic place related to the page
content. Example: \code{"Atlanta, Georgia"}.}

\item{...}{Additional geotagging metadata keyword and value pairs, such as
\code{geo.country}, \code{geo.a1}, ..., \code{geo.a3}, etc. Underscores in the keyword
will be converted to periods, so you can also specify \code{geo_country} in
place of \code{geo.country}.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Geotagging Metadata Tags
}
\examples{
meta() \%>\%
  meta_geo(
    icbm = c(50.167958, -97.133185),
    geo_position = c(50.167958, -97.133185),
    geo_placename = "Manitoba, Canada",
    geo_region = "ca-mb"
  )

}
\references{
\href{https://en.wikipedia.org/wiki/ICBM_address#Modern_use}{ICBM on Wikipedia},
\href{https://en.wikipedia.org/wiki/Geotagging#HTML_pages}{Geotagging on Wikipedia}
}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
