% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meteSSF.R
\name{meteSSF}
\alias{meteSSF}
\title{meteSSF}
\usage{
meteSSF(spp, sppID, abund, row, col, x, y, n0 = sum(abund), A, A0)
}
\arguments{
\item{spp}{A vector of species names}

\item{sppID}{A character giving the name of the desired species (as it appears in `spp')}

\item{abund}{A vector of abundances}

\item{row}{A vector of row IDs for each observation}

\item{col}{A vector of column IDs for each observation}

\item{x}{A vector of x coordinates for each observation}

\item{y}{A vector of y coordinates for each observation}

\item{n0}{Total abundance in area A0}

\item{A}{The area at which abundances were recorded}

\item{A0}{Total study area}
}
\value{
An object of class \code{meteSSF} with elements
\describe{
  \item{\code{data}}{The data used to construct the SSF}
  \item{\code{La}}{Vector of Lagrange multipliers}
  \item{\code{La.info}}{Termination information from optimization procedure}
  \item{\code{state.var}}{State variables used to constrain entropy maximization}
}
}
\description{
\code{meteSSF} calculates the ``spatial structure
function'' \eqn{\Pi(n)} (analogous to the ecosystem structure function). From
the SSF the spatial abundance distribution can be calculated.
}
\details{
Uses either data or state variables to calculate the Spatial Structure
Function (SSF). Uses internal code to determine when computation-saving approximations
can be safely made
}
\examples{
data(anbo)
## calculate SSF Pi
pi1 <- meteSSF(anbo$spp, 'crcr', anbo$count, row=anbo$row, col=anbo$column, A=1, A0=16)
pi1
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
metePi
}
\keyword{METE,}
\keyword{MaxEnt}
\keyword{lagrange}
\keyword{multiplier,}

