% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{humidity_relative2dewtemperature}
\alias{humidity_relative2dewtemperature}
\alias{humidity_dewtemperature2relative}
\alias{humidity_specific2relative}
\alias{humidity_relative2specific}
\title{Humidity conversion tools}
\usage{
humidity_relative2dewtemperature(Tc, HR)

humidity_dewtemperature2relative(Tc, Td, allowSaturated = FALSE)

humidity_specific2relative(Tc, HS, allowSaturated = FALSE)

humidity_relative2specific(Tc, HR)
}
\arguments{
\item{Tc}{A numeric vector of temperature in degrees Celsius.}

\item{HR}{A numeric vector of relative Humidity (in \%).}

\item{Td}{A numeric vector of dew temperature in degrees Celsius.}

\item{allowSaturated}{Logical flag to allow values over 100\%}

\item{HS}{A numeric vector of specific humidity (unitless).}
}
\value{
A numeric vector with specific or relative humidity.
}
\description{
Functions to transform relative humidity to specific humidity or dew point
temperature and viceversa.
}
\seealso{
\code{\link{meteocomplete}}
}
\author{
Nicholas Martin-StPaul, INRA

Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
