% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatStMoE.R
\docType{class}
\name{StatStMoE-class}
\alias{StatStMoE-class}
\alias{StatStMoE}
\title{A Reference Class which contains statistics of a StMoE model.}
\description{
StatStMoE contains all the statistics associated to a \link[=ParamStMoE]{StMoE}
model. It mainly includes the E-Step of the ECM algorithm calculating the
posterior distribution of the hidden variables, as well as the calculation of
the log-likelhood.
}
\section{Fields}{

\describe{
\item{\code{piik}}{Matrix of size \eqn{(n, K)} representing the probabilities
\eqn{\pi_{k}(x_{i}; \boldsymbol{\Psi}) = P(z_{i} = k | \boldsymbol{x};
  \Psi)}{\pi_{k}(x_{i}; \Psi) = P(z_{i} = k | x; \Psi)} of the latent
variable \eqn{z_{i}, i = 1,\dots,n}.}

\item{\code{z_ik}}{Hard segmentation logical matrix of dimension \eqn{(n, K)}
obtained by the Maximum a posteriori (MAP) rule: \eqn{z\_ik = 1 \
  \textrm{if} \ z\_ik = \textrm{arg} \ \textrm{max}_{s} \ \tau_{is};\ 0 \
  \textrm{otherwise}}{z_ik = 1 if z_ik = arg max_s \tau_{is}; 0 otherwise},
\eqn{k = 1,\dots,K}.}

\item{\code{klas}}{Column matrix of the labels issued from \code{z_ik}. Its elements are
\eqn{klas(i) = k}, \eqn{k = 1,\dots,K}.}

\item{\code{tik}}{Matrix of size \eqn{(n, K)} giving the posterior probability
\eqn{\tau_{ik}}{\tauik} that the observation \eqn{y_{i}}{yi} originates
from the \eqn{k}-th expert.}

\item{\code{Ey_k}}{Matrix of dimension \emph{(n, K)} giving the estimated means of
the experts.}

\item{\code{Ey}}{Column matrix of dimension \emph{n} giving the estimated mean of the StMoE.}

\item{\code{Var_yk}}{Column matrix of dimension \emph{K} giving the estimated means
of the experts.}

\item{\code{Vary}}{Column matrix of dimension \emph{n} giving the estimated variance
of the response.}

\item{\code{loglik}}{Numeric. Observed-data log-likelihood of the StMoE model.}

\item{\code{com_loglik}}{Numeric. Complete-data log-likelihood of the StMoE model.}

\item{\code{stored_loglik}}{Numeric vector. Stored values of the log-likelihood at
each ECM iteration.}

\item{\code{BIC}}{Numeric. Value of BIC (Bayesian Information Criterion).}

\item{\code{ICL}}{Numeric. Value of ICL (Integrated Completed Likelihood).}

\item{\code{AIC}}{Numeric. Value of AIC (Akaike Information Criterion).}

\item{\code{log_piik_fik}}{Matrix of size \eqn{(n, K)} giving the values of the
logarithm of the joint probability \eqn{P(y_{i}, \ z_{i} = k |
  \boldsymbol{x}, \boldsymbol{\Psi})}{P(y_{i}, z_{i} = k | x, \Psi)}, \eqn{i
  = 1,\dots,n}.}

\item{\code{log_sum_piik_fik}}{Column matrix of size \emph{m} giving the values of
\eqn{\textrm{log} \sum_{k = 1}^{K} P(y_{i}, \ z_{i} = k | \boldsymbol{x},
  \boldsymbol{\Psi})}{log \sum_{k = 1}^{K} P(y_{i}, z_{i} = k | x, \Psi)},
\eqn{i = 1,\dots,n}.}

\item{\code{dik}}{It represents the value of \eqn{d_{ik}}{dik}.}

\item{\code{wik}}{Conditional expectations \eqn{w_{ik}}{wik}.}

\item{\code{E1ik}}{Conditional expectations \eqn{e_{1,ik}}{e1ik}.}

\item{\code{E2ik}}{Conditional expectations \eqn{e_{2,ik}}{e2ik}.}

\item{\code{E3ik}}{Conditional expectations \eqn{e_{3,ik}}{e3ik}.}

\item{\code{stme_pdf}}{Skew-t mixture of experts density.}
}}

\section{Methods}{

\describe{
\item{\code{computeLikelihood(reg_irls)}}{Method to compute the log-likelihood. \code{reg_irls} is the value of
the regularization part in the IRLS algorithm.}

\item{\code{computeStats(paramStMoE)}}{Method used in the ECM algorithm to compute statistics based on
parameters provided by the object \code{paramStMoE} of class
\link{ParamStMoE}.}

\item{\code{EStep(paramStMoE, calcTau = FALSE, calcE1 = FALSE, calcE2 = FALSE,
  calcE3 = FALSE)}}{Method used in the ECM algorithm to update statistics based on parameters
provided by the object \code{paramStMoE} of class \link{ParamStMoE}
(prior and posterior probabilities).}

\item{\code{MAP()}}{MAP calculates values of the fields \code{z_ik} and \code{klas}
      by applying the Maximum A Posteriori Bayes allocation rule.

      \eqn{z_{ik} = 1 \ \textrm{if} \ k = \textrm{arg} \ \textrm{max}_{s}
      \ \tau_{is};\ 0 \ \textrm{otherwise}}{
      z_{ik} = 1 if z_ik = arg max_{s} \tau_{is}; 0 otherwise}}
}}

\seealso{
\link{ParamStMoE}
}
