% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/betaLinker.R
\name{betaLinker}
\alias{betaLinker}
\title{Run spatial simulations, null and beta metric calculations}
\usage{
betaLinker(no.taxa, arena.length, mean.log.individuals, length.parameter,
  sd.parameter, max.distance, proportion.killed, competition.iterations,
  no.plots, plot.length, randomizations, cores, simulations, nulls, metrics)
}
\arguments{
\item{no.taxa}{The desired number of species in the input phylogeny}

\item{arena.length}{A numeric, specifying the length of a single side of the arena}

\item{mean.log.individuals}{Mean log of abundance vector from which species abundances
will be drawn}

\item{length.parameter}{Length of vector from which species' locations are drawn. Large
values of this parameter dramatically decrease the speed of the function but result in
nicer looking communities}

\item{sd.parameter}{Standard deviation of vector from which species' locations are
drawn}

\item{max.distance}{The geographic distance within which neighboring
indivduals should be considered to influence the individual in question}

\item{proportion.killed}{The percent of individuals in the total arena that should be
considered (as a proportion, e.g. 0.5 = half)}

\item{competition.iterations}{Number of generations over which to run competition
simulations}

\item{no.plots}{Number of plots to place}

\item{plot.length}{Length of one side of desired plot}

\item{randomizations}{The number of randomized CDMs, per null, to generate. These are
used to compare the significance of the observed metric scores.}

\item{cores}{The number of cores to be used for parallel processing.}

\item{simulations}{Optional list of named spatial simulation functions to use. These
must be defined in the defineSimulations function. If invoked, this option will likely
be used to run a subset of the defined spatial simulations.}

\item{nulls}{Optional list of named null model functions to use. If invoked, this
option will likely be used to run a subset of the defined null models.}

\item{metrics}{Optional list of named metric functions to use. If invoked, this option
will likely be used to run a subset of the defined metrics.}
}
\value{
A list with two elements. The first is a list of data frames, with one for each
spatial simulation. These provide the observed beta metric scores for each spatial
simulation. The second level is a list of lists, one for each spatial simulation. Each
of these is a list of data frames. There is one data frame per null model, and it
summarizes the randomized metric scores for that null model for that spatial
simulation. Note that this is slightly different than the regular linker() function,
which does not output these raw metric scores (that function calculates SES and CI as
outputs).
}
\description{
This function wraps a number of wrapper functions into one big metric + null
tester function. Only a single test is performed, with results saved into memory.
}
\details{
This function wraps a number of other wrapper functions into
one big beta metric + null performance tester function. Only a single test is run,
with results saved into memory. To perform multiple complete tests, use the
multiLinker function, which saves results to file.
}
\examples{
#not run
#system.time(test <- betaLinker(no.taxa=50, arena.length=300, mean.log.individuals=2,
	#length.parameter=5000, sd.parameter=50, max.distance=30, proportion.killed=0.2,
	#competition.iterations=3, no.plots=15, plot.length=30,
	#randomizations=3, cores=1,
	#nulls=list("richness"=metricTester:::my_richnessNull,
	#"frequency"=metricTester:::my_frequency)))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

