% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSimulations.R
\name{checkSimulations}
\alias{checkSimulations}
\title{Confirm that the spatial simulation functions are in suitable format}
\usage{
checkSimulations(x, new_ = FALSE)
}
\arguments{
\item{x}{Optional. If not provided, defines the simulations as those in
defineSimulations. Else
either a character vector or a named list of functions, depending on whether new_ is
set to TRUE or FALSE. See runSimulations.}

\item{new_}{Whether or not new simulations are being defined on the fly. Default is
FALSE. Set to TRUE if a new simulation is being used.}
}
\value{
A list of functions.
}
\description{
Utility function. Creates a list of spatial simulations, either those defined in
defineSimulations or a named list of simulation functions.
}
\details{
A few quick checks to confirm the spatial simulations are in suitable format.
}
\examples{
checkSimulations(names(defineSimulations()))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
