% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{maiquetia}
\alias{maiquetia}
\title{Maiquetia Daily Rainfall}
\format{a vector of size 14244 containing daily rainfall (in mm),}
\source{
J.R. Cordova and M. González, accessed 25.11.2018 from <https://rss.onlinelibrary.wiley.com/hub/journal/14679876/series-c-datasets>
}
\description{
Daily cumulated rainfall (in mm) at Maiquetia airport, Venezuela.
The observations cover the period from January 1961 to December 1999.
The original series had missing days in February 1996 (during which there were
2 days with 1hr each of light rain) and January 1998 (no rain). These were replaced by zeros.
}
\examples{
\dontrun{
data(maiquetia, package = "mev")
day <- seq.Date(from = as.Date("1961-01-01"), to = as.Date("1999-12-31"), by = "day")
nzrain <- maiquetia[substr(day, 1, 4) < 1999 & maiquetia > 0]
fit.gpd(nzrain, threshold = 30, show = TRUE)

}
}
\references{
Coles, S. and L.R. Pericchi (2003). Anticipating Catastrophes through Extreme Value Modelling, \emph{Applied Statistics}, \bold{52}(4), 405-416.

Coles, S., Pericchi L.R. and S. Sisson (2003). A fully probabilistic approach to extreme rainfall modeling, \emph{Journal of Hydrology}, \bold{273}, 35-50.
}
