% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_report.R
\name{read_report}
\alias{read_report}
\title{Read an MGI report}
\usage{
read_report(
  report_file,
  report_type = c("MRK_List1", "MRK_List2", "MGI_MRK_Coord", "MGI_Gene_Model_Coord",
    "MGI_GTGUP", "MRK_Sequence", "MRK_SwissProt_TrEMBL", "MRK_SwissProt", "MRK_GeneTrap",
    "MRK_ENSEMBL", "MGI_BioTypeConflict", "PRB_PrimerSeq", "MGI_InterProDomains"),
  n_max = Inf
)
}
\arguments{
\item{report_file}{A path or URL to an MGI report file.}

\item{report_type}{Report type, one of:
\itemize{
\item \code{"MRK_List1"}: Mouse Genetic Markers (including withdrawn marker symbols).
\item \code{"MRK_List2"}: Mouse Genetic Markers (excluding withdrawn marker symbols).
\item \code{"MGI_MRK_Coord"}: MGI Marker Coordinates.
\item \code{"MGI_GTGUP"}: MGI Sequence Coordinates.
\item \code{"MRK_Sequence"}: MGI Marker associations to Sequence (GenBank, RefSeq,
Ensembl) information.
\item \code{"MRK_SwissProt_TrEMBL"}: MGI Marker associations to SWISS-PROT and TrEMBL
protein IDs.
\item \code{"MRK_SwissProt"}: MGI Marker associations to SWISS-PROT protein IDs.
\item \code{"MRK_GeneTrap"}: MGI Marker associations to Gene Trap IDs.
\item \code{"MRK_ENSEMBL"}: MGI Marker associations to Ensembl sequence information.
\item \code{"MGI_BioTypeConflict"}: MGI Marker associations to Ensembl or NCBI gene
models where a gene vs. pseudogene discrepancy
exists.
\item \code{"PRB_PrimerSeq"}: MGI Marker associations with primer pairs.
\item \code{"MGI_InterProDomains"}: InterPro domain associations to MGI markers.
}}

\item{n_max}{Maximum number of lines to read.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the report data in tidy
format.
}
\description{
\code{\link[=read_report]{read_report()}} reads in an MGI report.
}
\examples{
base_url <- "https://www.informatics.jax.org/downloads/reports"
url <- file.path(base_url, "MRK_List1.rpt")
# Import the Mouse Genetic Markers (including withdrawn marker symbols) Report
read_report(url, "MRK_List1", n_max = 10L)

}
