\name{mi.completed}
\alias{mi.completed}
\alias{mi.data.frame}
\alias{mi.completed,mi-method}
\alias{mi.data.frame,mi-method}

\title{ 
    Multiply Imputed Dataframes
}

\description{
    Function to return completed data set from result of mi program.
}
\usage{
\S4method{mi.completed}{mi}(object)
\S4method{mi.data.frame}{mi}(object, m = 1)
}
\arguments{
    \item{object}{mi object containing a multiply imputed data set. 
        The \code{mi} object is generated by the \code{mi} function.}
    \item{m}{Index of the imputed data set. The default is 1.}
}
\value{
    A data set or a list of datasets with the missing data imputed.
}
\references{ 
    Andrew Gelman and M. Grazia Pittau.
    \dQuote{A flexible program for missing-data imputation and model checking}. 
    \emph{Technical report}. Columbia University, New York;
  
    Andrew Gelman and Jennifer Hill. (2007).
    \emph{Data Analysis Using Regression and Multilevel/Hierarchical Models}.
    Cambridge University Press.
}

\author{
  Yu-Sung Su \email{ys463@columbia.edu}
  Masanao Yajima \email{yajima@stat.columbia.edu},
  Andrew Gelman \email{gelman@stat.columbia.edu}
}
\seealso{
    \code{\link{mi}}
}
\examples{
  data(CHAIN)
  IMP <- mi (CHAIN, n.iter=6, add.priors=FALSE)
  # get all imputed dataset
  imputed.matrix <- mi.completed (IMP)  
  # get the 3rd chain of the imputed dataset
  imputed.data.frame <- mi.data.frame(IMP, m=3) 
}
\keyword{models}
\keyword{manip}
\keyword{methods}
