\name{md.pattern}
\alias{md.pattern}
\title{Missing Data Pattern}
\usage{
md.pattern(x)
}
\arguments{
\item{x}{A data frame or a matrix containing the incomplete data. 
  Missing values are coded as NA's. }
}
\description{
Display missing-data patterns.
}

\value{
    A matrix with \code{ncol(x)+1} columns, in which each row corresponds to
        a missing data pattern (1=observed, 0=missing). 
    Rows and columns are sorted in increasing amounts of missing 
    information. The last column and row contain row and column counts,
    respectively.
    
}
\details{
    This function is useful for investigating any structure of missing 
    observation in the data. In specific case, the missing data pattern 
    could be (nearly) monotone. Monotonicity can be used to simplify the 
    imputation model. See Schafer (1997) for details. Also, the missing
    pattern could suggest which variables could potentially be useful for
    imputation of missing entries.
}
\references{
    Schafer, J.L. (1997), Analysis of multivariate incomplete data. 
    London: Chapman&Hall.

Van Buuren, S., Groothuis-Oudshoorn, K. (2009) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}

}
\examples{

md.pattern(nhanes)
#     age hyp bmi chl    
#  13   1   1   1   1  0
#   1   1   1   0   1  1
#   3   1   1   1   0  1
#   1   1   0   0   1  2
#   7   1   0   0   0  3
#   0   8   9  10 27


}

\author{Stef van Buuren, Karin Oudshoorn, 2000}     

\keyword{univar} 
