% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{cmpoutput}
\alias{cmpoutput}
\title{Compares output observations from two or more groups}
\usage{
cmpoutput(name, ve_npcs, data, obs_lvls, lim_npcs = TRUE, mnv_test = "Pillai")
}
\arguments{
\item{name}{Comparison name (useful when calling this function to perform
multiple comparisons).}

\item{ve_npcs}{Percentage (\code{0 < ve_npcs < 1}) of variance explained by
the \emph{q} principal components (i.e. number of dimensions) used in MANOVA,
or the number of principal components (\code{ve_npcs > 1}, must be integer).
Can be a vector, in which case the MANOVA test will be applied multiple
times, one per specified variance to explain / number of principal
components.}

\item{data}{A \emph{n} x \emph{m} matrix, where \emph{n} is the total number
of output observations (runs) and \emph{m} is the number of variables (i.e.
output length).}

\item{obs_lvls}{Levels or groups associated with each observation.}

\item{lim_npcs}{Limit number of principal components used for MANOVA to
minimum number of observations per group?}

\item{mnv_test}{The name of the test statistic to be used in MANOVA, as
described in \code{\link[stats]{summary.manova}}.}
}
\value{
Object of class \code{cmpoutput} containing the following data:
\describe{
 \item{scores}{\emph{n} x \emph{n} matrix containing projections of
       output data in the principal components space. Rows correspond to
       observations, columns to principal components. }
 \item{obs_lvls}{Levels or groups associated with each observation.}
 \item{varexp}{Percentage of variance explained by each principal component.}
 \item{npcs}{Number of principal components specified in \code{ve_npcs} OR
       which explain the variance percentages given in \code{ve_npcs}.}
 \item{ve}{Percentage (between 0 and 1) of variance explained by the \emph{q}
       principal components (i.e. number of dimensions) used in MANOVA.}
 \item{name}{Comparison name (useful when calling this function to perform
       multiple comparisons).}
 \item{p.values}{\emph{P}-values for the performed statistical tests, namely:
   \describe{
     \item{manova}{List of \emph{p}-values for the MANOVA test for each
           number of principal component in \code{npcs}.}
     \item{parametric}{Vector of \emph{p}-values for the parametric test
           applied to groups along each principal component (\emph{t}-test
           for 2 groups, ANOVA for more than 2 groups).}
     \item{nonparametric}{Vector of \emph{p}-values for the non-parametric
           test applied to groups along each principal component
           (Mann-Whitney U test for 2 groups, Kruskal-Wallis test for more
           than 2 groups).}
     \item{parametric_adjusted}{Same as field \code{parametric}, but
           \emph{p}-values are adjusted using weighted Bonferroni procedure.
           Percentages of explained variance are used as weights.}
     \item{nonparametric_adjusted}{Same as field \code{nonparametric}, but
           \emph{p}-values are adjusted using weighted Bonferroni procedure.
           Percentages of explained variance are used as weights.}
   }
 }
 \item{tests}{
   \describe{
     \item{manova}{Objects returned by the \code{\link[stats]{manova}}
           function for each value specified in \code{ve_npcs}.}
     \item{parametric}{List of objects returned by applying
           \code{\link[stats]{t.test}} (two groups) or
           \code{\link[stats]{aov}} (more than two groups) to each principal
           component.}
     \item{nonparametric}{List of objects returned by applying
           \code{\link[stats]{wilcox.test}} (two groups) or
           \code{\link[stats]{kruskal.test}} (more than two groups) to each
           principal component.}
   }
 }
}
}
\description{
Compares output observations from two or more groups.
}
\examples{

# Comparing the first output ("Pop.Sheep") of one the provided datasets.
cmp <-
 cmpoutput("SheepPop", 0.8, pphpc_ok$data[["Pop.Sheep"]], pphpc_ok$obs_lvls)

# Compare bogus outputs created from 2 random sources, 5 observations per
# source, 20 variables each, yielding a 10 x 20 data matrix.
data <- matrix(c(rnorm(100), rnorm(100, mean = 1)), nrow = 10, byrow = TRUE)
olvls <- factor(c(rep("A", 5), rep("B", 5)))
cmp <- cmpoutput("Bogus", 0.7, data, olvls)

}
