% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{ma_evaluate}
\alias{ma_evaluate}
\title{Evaluate API}
\usage{
ma_evaluate(
  query,
  count = 10,
  offset = 0,
  orderby = NULL,
  atts = c("Id", "AA.AuN", "J.JN", "Ti", "Y", "CC"),
  model = "latest",
  key = NULL,
  ...
)
}
\arguments{
\item{query}{(character) query terms}

\item{count}{(intger) number of records to return. default: 10}

\item{offset}{(intger) record number to start at. default: 0}

\item{orderby}{(logical) column by which to order. default: none}

\item{atts}{(character) fields to return, in a character vector. See
https://docs.microsoft.com/en-us/academic-services/project-academic-knowledge/reference-entity-attributes
for details.}

\item{model}{(character) Name of the model that you wish to query. One
of 'latest' or 'beta-2015'. Default: latest}

\item{key}{(character) microsoft academic API key, see the \code{Authentication}
section in \link{microdemic-package}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a list of length two, with \code{expr} (character) and
\code{entities} (data.frame)
}
\description{
Evaluate API
}
\examples{
\dontrun{
# any numeric value that starts with 19
ma_evaluate(query = "Y='19'...")
# author name matching, and request certain fields back
ma_evaluate(query = "Composite(AA.AuN=='smith')",
  atts = c('Id', 'AA.AuN'))
# matching year 2010 and request Id and Y fields
ma_evaluate(query = "Y=2010", atts = c('Id', 'Y'))
# range of years: includes only left boundary value: 2010, 2012
ma_evaluate(query = "Y=[2010, 2012)", atts = c('Id', 'Y'))
# range by specific dates
ma_evaluate(query = "D=['2010-02-03','2010-02-05']", atts = c('Id', 'Y'))
# matching author and matching affiliation
x <- "Composite(And(AA.AuN='mike smith',AA.AfN='harvard university'))"
ma_evaluate(x)
}
}
\references{
Query expression syntax
https://docs.microsoft.com/en-us/academic-services/project-academic-knowledge/reference-query-expression-syntax
}
