% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid.R
\name{ggmid}
\alias{ggmid}
\alias{ggmid.mid}
\alias{autoplot.mid}
\title{Plot MID with ggplot2 Package}
\usage{
ggmid(object, ...)

\method{ggmid}{mid}(
  object,
  term,
  type = c("effect", "data", "compound"),
  theme = NULL,
  intercept = FALSE,
  main.effects = FALSE,
  data = NULL,
  jitter = 0.3,
  cells.count = c(100L, 100L),
  limits = c(NA, NA),
  ...
)

\method{autoplot}{mid}(object, ...)
}
\arguments{
\item{object}{a "mid" object to be visualized.}

\item{...}{optional parameters to be passed to the main layer.}

\item{term}{a character string specifying the component function to be plotted.}

\item{type}{character string. The method for plotting the interaction effects.}

\item{theme}{a character string specifying the color theme or any item that can be used to define "color.theme" object.}

\item{intercept}{logical. If \code{TRUE}, the intercept is added to the MID values.}

\item{main.effects}{logical. If \code{TRUE}, the main effects are included in the interaction plot.}

\item{data}{a data.frame to be plotted with the corresponding MID values. If not passed, data is extracted from \code{parent.env()} based on the function call of the "mid" object.}

\item{jitter}{a numeric value specifying the amount of jitter for points.}

\item{cells.count}{an integer or integer-valued vector of length two, specifying the number of cells for the raster type interaction plot.}

\item{limits}{\code{NULL} or a numeric vector of length two specifying the limits of the plotting scale. \code{NA}s are replaced by the minimum and/or maximum MID values.}
}
\value{
\code{ggmid.mid()} returns a "ggplot" object.
}
\description{
For "mid" objects, \code{ggmid()} visualizes a MID component function using the ggplot2 package.
}
\details{
The S3 method of \code{ggmid()} for "mid" objects creates a "ggplot" object that visualizes a MID component function.
The main layer is drawn using \code{geom_line()} or \code{geom_path()} for a main effect of a quantitative variable, \code{geom_col()} for a main effect of a qualitative variable, and \code{geom_raster()} or \code{geom_rect()} for an interaction effect.
For other methods of \code{ggmid()}, see \code{help(ggmid.mid.importance)}, \code{help(ggmid.mid.breakdown)} or \code{help(ggmid.mid.conditional)}.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
ggmid(mid, "carat")
ggmid(mid, "clarity")
ggmid(mid, "carat:clarity", main.effects = TRUE)
ggmid(mid, "clarity:color", type = "data", theme = "Mako", data = diamonds[idx, ])
ggmid(mid, "carat:color", type = "compound", data = diamonds[idx, ])
}
