% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mig_hist.R
\name{plot_mig_hist}
\alias{plot_mig_hist}
\title{Plot a migration history.}
\usage{
plot_mig_hist(date_crossing, is_arrival, days_to_next_crossing,
  res_status_before_str = NULL, res_status_after_str = NULL,
  date_first = NULL, date_last = NULL, show_dates = TRUE,
  show_days = TRUE, cex = 1, lwd = 1)
}
\arguments{
\item{date_crossing}{A vector of dates.}

\item{is_arrival}{A logical vector, the same length as \code{date_crossing}
specifying whether each border crossing is an arrival.}

\item{days_to_next_crossing}{A number vector, the same length as
\code{date_crossing} specifying the days span between two journeys.}

\item{res_status_before_str}{Character or numeric vector,
the same length as \code{date_crossing}, showing residence
status before each crossing. Optional.}

\item{res_status_after_str}{Character or numeric vector,
the same length as \code{date_crossing}, showing residence
status after each crossing.}

\item{date_first}{The start date for the travel history. Optional.}

\item{date_last}{The end date for the travel history. Optional.}

\item{show_dates}{Logical. Whether to display the dates of each border
crossing.}

\item{show_days}{Logical. Whether to display the length, in days, of each
spell in or out of the country.}

\item{cex}{'Character expansion factor'. A number. Larger values
lead to larger text. Defaults to 1.}

\item{lwd}{Line width. A number. Larger values lead to thicker lines.
Defaults to 1.}
}
\value{
Returns \code{NULL}, but as a side effect draws a graph
(using R's traditional graphics system).
}
\description{
Given a sequence of border crossings for a person,
draw a diagram describing that person's migration
history.

Note that, unlike elsewhere in package \code{migrbc}, the
\code{date_crossing} and \code{is_arrival} arguments for
\code{plot_mig_hist} refer to a single individual.

If values for \code{date_first} and \code{date_last} are not supplied,
then defaults are calculated, based on the length of the travel history.
}
\examples{
## to suppresse log messages to the console
migrbc::initialize_logger(log_level = 1)

plot_test <- function(mig_hist) {
  plot_mig_hist(date_crossing = as.character(mig_hist$date_crossing), 
                is_arrival = mig_hist$is_arrival,
                days_to_next_crossing = mig_hist$days_to_next_crossing,
                show_date = FALSE, 
                cex = 0.8)
}
number_of_people = 1
person_data <- migrbc::setup_random_test_data(number_of_people, 
                                              initial_date = '2001-01-01', 
                                              numJourneys = 3,
                                              min = 0, 
                                             max = 100)
cross_spaces <- migrbc::pre_process(person_data, n_groups = 1)
## run in non-parallel
post_data <- migrbc::run_rbc(cross_spaces, 
                       window_size = 487, 
                       threshold_year = 365, 
                       parallel=FALSE)
old_par <- par(mfrow = c(1, 1))
plot_test(post_data$journeys)
par(old_par)

}
