% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_filename.R
\name{get_filename}
\alias{get_filename}
\title{Extract Filenames from File Paths}
\usage{
get_filename(paths, rm_extension = TRUE, rm_path = TRUE)
}
\arguments{
\item{paths}{A \code{character} vector containing file system paths.
Must be valid and accessible path strings.}

\item{rm_extension}{A \code{logical} flag controlling file extension removal:
\itemize{
\item \code{TRUE}: Strips file extensions from filenames
\item \code{FALSE}: Preserves complete filename with extension
Default is \code{TRUE}.
}}

\item{rm_path}{A \code{logical} flag managing directory path handling:
\itemize{
\item \code{TRUE}: Extracts only the filename, discarding directory information
\item \code{FALSE}: Retains complete path information
Default is \code{TRUE}.
}}
}
\value{
A \code{character} vector of processed filenames with applied transformations.
}
\description{
The \code{get_filename} function extracts filenames from file paths with options to remove file extensions
and/or directory paths.
}
\details{
The function performs the following operations:
\itemize{
\item Validates input paths
\item Handles empty input vectors
\item Optionally removes directory paths using \code{\link[base]{basename}}
\item Optionally removes file extensions using regex substitution
}
}
\note{
\itemize{
\item If both \code{rm_extension} and \code{rm_path} are FALSE,
a warning is issued and the original paths are returned
\item Supports multiple file paths in the input vector
}
}
\examples{
# Example: File path processing demonstrations

# Setup test files
xlsx_files <- mintyr_example(
  mintyr_examples("xlsx_test")    # Get example Excel files
)

# Example 1: Extract filenames without extensions
get_filename(
  xlsx_files,                     # Input file paths
  rm_extension = TRUE,            # Remove file extensions
  rm_path = TRUE                  # Remove directory paths
)

# Example 2: Keep file extensions
get_filename(
  xlsx_files,                     # Input file paths
  rm_extension = FALSE,           # Keep file extensions
  rm_path = TRUE                  # Remove directory paths
)

# Example 3: Keep full paths without extensions
get_filename(
  xlsx_files,                     # Input file paths
  rm_extension = TRUE,            # Remove file extensions
  rm_path = FALSE                 # Keep directory paths
)
}
\seealso{
\itemize{
\item \code{\link[base:basename]{base::basename()}} for basic filename extraction
}
}
