% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{everywhere}
\alias{everywhere}
\title{Evaluate Everywhere}
\usage{
everywhere(.expr, ..., .args = list(), .compute = NULL)
}
\arguments{
\item{.expr}{an expression to evaluate asynchronously (of arbitrary length,
wrapped in \{ \} where necessary), \strong{or else} a pre-constructed language
object.}

\item{...}{(optional) \strong{either} named arguments (name = value pairs)
specifying objects referenced, but not defined, in \code{.expr}, \strong{or} an
environment containing such objects. See 'evaluation' section below.}

\item{.args}{(optional) \strong{either} a named list specifying objects
referenced, but not defined, in \code{.expr}, \strong{or} an environment containing
such objects. These objects will remain local to the evaluation environment
as opposed to those supplied in \code{...} above - see 'evaluation' section
below.}

\item{.compute}{[default NULL] character value for the compute profile
to use (each has its own independent set of daemons), or NULL to use the
'default' profile.}
}
\value{
A 'mirai_map' (list of 'mirai' objects).
}
\description{
Evaluate an expression 'everywhere' on all connected daemons for the
specified compute profile - this must be set prior to calling this function.
Performs operations across daemons such as loading packages or exporting
common data. Resultant changes to the global environment, loaded packages and
options are persisted regardless of a daemon's \code{cleanup} setting.
}
\details{
If using dispatcher, this function forces a synchronization point at
dispatcher, whereby the \code{\link[=everywhere]{everywhere()}} call must have been evaluated on all
daemons prior to subsequent mirai evaluations taking place.

Calling \code{\link[=everywhere]{everywhere()}} does not affect the RNG stream for mirai calls when
using a reproducible \code{seed} value at \code{\link[=daemons]{daemons()}}. This allows the seed
associated for each mirai call to be the same, regardless of the number of
daemons actually used to evaluate the code. Note that this means the code
evaluated in an \code{\link[=everywhere]{everywhere()}} call is itself non-reproducible if it should
involve random numbers.
}
\section{Evaluation}{


The expression \code{.expr} will be evaluated in a separate R process in a clean
environment (not the global environment), consisting only of the objects
supplied to \code{.args}, with the objects passed as \code{...} assigned to the global
environment of that process.

As evaluation occurs in a clean environment, all undefined objects must be
supplied through \code{...} and/or \code{.args}, including self-defined functions.
Functions from a package should use namespaced calls such as
\code{mirai::mirai()}, or else the package should be loaded beforehand as part of
\code{.expr}.

For evaluation to occur \emph{as if} in your global environment, supply objects to
\code{...} rather than \code{.args}, e.g. for non-local variables or helper functions
required by other functions, as scoping rules may otherwise prevent them from
being found.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(1)

# export common data by a super-assignment expression:
everywhere(y <<- 3)
mirai(y)[]

# '...' variables are assigned to the global environment
# '.expr' may be specified as an empty {} in such cases:
everywhere({}, a = 1, b = 2)
mirai(a + b - y == 0L)[]

# everywhere() returns a mirai_map object:
mp <- everywhere("just a normal operation")
mp
mp[.flat]
mp <- everywhere(stop("everywhere"))
collect_mirai(mp)
daemons(0)

# loading a package on all daemons
daemons(1, dispatcher = FALSE)
everywhere(library(parallel))
m <- mirai("package:parallel" \%in\% search())
m[]
daemons(0)
\dontshow{\}) # examplesIf}
}
