% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\docType{methods}
\name{coef-method}
\alias{coef,DiscreteClass-method}
\alias{coef,MixedClass-method}
\alias{coef,MultipleGroupClass-method}
\alias{coef,SingleGroupClass-method}
\alias{coef-method}
\title{Extract raw coefs from model object}
\usage{
\S4method{coef}{SingleGroupClass}(object, CI = 0.95, printSE = FALSE,
  rotate = "none", Target = NULL, digits = 3, IRTpars = FALSE,
  rawug = FALSE, as.data.frame = FALSE, simplify = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{MixedClass}}

\item{CI}{the amount of converged used to compute confidence intervals; default is
95 percent confidence intervals}

\item{printSE}{logical; print the standard errors instead of the confidence intervals?}

\item{rotate}{see \code{\link{mirt}} for details. The default rotation is \code{'none'}}

\item{Target}{a dummy variable matrix indicting a target rotation pattern}

\item{digits}{number of significant digits to be rounded}

\item{IRTpars}{logical; convert slope intercept parameters into traditional IRT parameters?
Only applicable to unidimensional models}

\item{rawug}{logical; return the untransformed internal g and u parameters?
If \code{FALSE}, g and u's are converted with the original format along with delta standard errors}

\item{as.data.frame}{logical; convert list output to a data.frame instead?}

\item{simplify}{logical; if all items have the same parameter names (indicating they are
of the same class) then they are collapsed to a matrix, and a list of length 2 is returned
containing a matrix of item parameters and group-level estimates}

\item{verbose}{logical; allow information to be printed to the console?}

\item{...}{additional arguments to be passed}
}
\description{
Return a list (or data.frame) of raw item and group level coefficients.
}
\examples{
\dontrun{
dat <- expand.table(LSAT7)
x <- mirt(dat, 1)
coef(x)
coef(x, IRTpars = TRUE)
coef(x, simplify = TRUE)

#with computed information matrix
x <- mirt(dat, 1, SE = TRUE)
coef(x)
coef(x, printSE = TRUE)
coef(x, as.data.frame = TRUE)

#two factors
x2 <- mirt(Science, 2)
coef(x2)
coef(x2, rotate = 'varimax')

}
}
\seealso{
\code{\link{summary-method}}
}

