% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultipleGroup-methods.R,
%   R/SingleGroup-methods.R
\docType{methods}
\name{plot,MultipleGroupClass,missing-method}
\alias{plot,MultipleGroupClass,missing-method}
\alias{plot-method}
\alias{plot,SingleGroupClass-method}
\alias{plot,MultipleGroupClass-method}
\alias{plot,SingleGroupClass,missing-method}
\alias{plot,DiscreteClass,missing-method}
\alias{plot,MixtureClass,missing-method}
\title{Plot various test-implied functions from models}
\usage{
\S4method{plot}{MultipleGroupClass,missing}(
  x,
  y,
  type = "score",
  npts = 200,
  drop2 = TRUE,
  degrees = 45,
  which.items = 1:extract.mirt(x, "nitems"),
  rot = list(xaxis = -70, yaxis = 30, zaxis = 10),
  facet_items = TRUE,
  theta_lim = c(-6, 6),
  par.strip.text = list(cex = 0.7),
  par.settings = list(strip.background = list(col = "#9ECAE1"), strip.border = list(col
    = "black")),
  auto.key = list(space = "right", points = FALSE, lines = TRUE),
  ...
)

\S4method{plot}{SingleGroupClass,missing}(
  x,
  y,
  type = "score",
  npts = 200,
  drop2 = TRUE,
  degrees = 45,
  theta_lim = c(-6, 6),
  which.items = 1:extract.mirt(x, "nitems"),
  MI = 0,
  CI = 0.95,
  rot = list(xaxis = -70, yaxis = 30, zaxis = 10),
  facet_items = TRUE,
  main = NULL,
  drape = TRUE,
  colorkey = TRUE,
  ehist.cut = 1e-10,
  add.ylab2 = TRUE,
  par.strip.text = list(cex = 0.7),
  par.settings = list(strip.background = list(col = "#9ECAE1"), strip.border = list(col
    = "black")),
  auto.key = list(space = "right", points = FALSE, lines = TRUE),
  profile = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{DiscreteClass}}

\item{y}{an arbitrary missing argument required for \code{R CMD check}}

\item{type}{type of plot to view. Can be
  \describe{
    \item{\code{'info'}}{test information function}
    \item{\code{'rxx'}}{for the reliability function}
    \item{\code{'infocontour'}}{for the test information contours}
    \item{\code{'SE'}}{for the test standard error function}
    \item{\code{'infotrace'}}{item information traceline plots}
    \item{\code{'infoSE'}}{a combined test information and standard error plot}
    \item{\code{'trace'}}{item probability traceline plots}
    \item{\code{'itemscore'}}{item scoring traceline plots}
    \item{\code{'score'}}{expected total score surface}
    \item{\code{'scorecontour'}}{expected total score contour plot}
  }

  Note that if \code{dentype = 'empiricalhist'} was used in estimation then
  the type \code{'empiricalhist'}
  also will be available to generate the empirical histogram plot, and if
  \code{dentype = 'Davidian-#'} was used then the type \code{'Davidian'}
  will also be available to generate the curve estimates at the quadrature
  nodes used during estimation}

\item{npts}{number of quadrature points to be used for plotting features.
Larger values make plots look smoother}

\item{drop2}{logical; where appropriate, for dichotomous response items drop the lowest category
and provide information pertaining only to the second response option?}

\item{degrees}{numeric value ranging from 0 to 90 used in \code{plot} to compute angle
for information-based plots with respect to the first dimension.
If a vector is used then a bubble plot is created with the summed information across the angles specified
(e.g., \code{degrees = seq(0, 90, by=10)})}

\item{which.items}{numeric vector indicating which items to be used when plotting. Default is
to use all available items}

\item{rot}{allows rotation of the 3D graphics}

\item{facet_items}{logical; apply grid of plots across items? If \code{FALSE}, items will be
placed in one plot for each group}

\item{theta_lim}{lower and upper limits of the latent trait (theta) to be evaluated, and is
used in conjunction with \code{npts}}

\item{par.strip.text}{plotting argument passed to \code{\link{lattice}}}

\item{par.settings}{plotting argument passed to \code{\link{lattice}}}

\item{auto.key}{plotting argument passed to \code{\link{lattice}}}

\item{...}{additional arguments to be passed to lattice}

\item{MI}{a single number indicating how many imputations to draw to form bootstrapped confidence
intervals for the selected test statistic. If greater than 0 a plot will be drawn with a shaded
region for the interval}

\item{CI}{a number from 0 to 1 indicating the confidence interval to select when MI input is
used. Default uses the 95\% confidence (CI = .95)}

\item{main}{argument passed to lattice. Default generated automatically}

\item{drape}{logical argument passed to lattice. Default generated automatically}

\item{colorkey}{logical argument passed to lattice. Default generated automatically}

\item{ehist.cut}{a probability value indicating a threshold for excluding cases in empirical
histogram plots. Values larger than the default will include more points in the tails of the
plot, potentially squishing the 'meat' of the plot to take up less area than visually desired}

\item{add.ylab2}{logical argument passed to lattice. Default generated automatically}

\item{profile}{logical; provide a profile plot of response probabilities (objects returned from
\code{\link{mdirt}} only)}
}
\description{
Plot various test implied response functions from models estimated in the mirt package.
}
\examples{

\dontrun{
x <- mirt(Science, 1, SE=TRUE)
plot(x)
plot(x, type = 'info')
plot(x, type = 'infotrace')
plot(x, type = 'infotrace', facet_items = FALSE)
plot(x, type = 'infoSE')
plot(x, type = 'rxx')

# confidence interval plots when information matrix computed
plot(x)
plot(x, MI=100)
plot(x, type='info', MI=100)
plot(x, type='SE', MI=100)
plot(x, type='rxx', MI=100)

# use the directlabels package to put labels on tracelines
library(directlabels)
plt <- plot(x, type = 'trace')
direct.label(plt, 'top.points')

set.seed(1234)
group <- sample(c('g1','g2'), nrow(Science), TRUE)
x2 <- multipleGroup(Science, 1, group)
plot(x2)
plot(x2, type = 'trace')
plot(x2, type = 'trace', which.items = 1:2)
plot(x2, type = 'itemscore', which.items = 1:2)
plot(x2, type = 'trace', which.items = 1, facet_items = FALSE) #facet by group
plot(x2, type = 'info')

x3 <- mirt(Science, 2)
plot(x3, type = 'info')
plot(x3, type = 'SE', theta_lim = c(-3,3))

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
