% Generated by roxygen2 (4.0.1): do not edit by hand
\name{extract.group}
\alias{extract.group}
\title{Extract a group from a multiple group mirt object}
\usage{
extract.group(x, group)
}
\arguments{
\item{x}{mirt model of class 'MultipleGroupClass'}

\item{group}{a number signifying which group should be extracted}
}
\description{
Extract a single group from an object defined by \code{\link{multipleGroup}}.
}
\examples{
\dontrun{
#' set.seed(12345)
a <- matrix(abs(rnorm(15,1,.3)), ncol=1)
d <- matrix(rnorm(15,0,.7),ncol=1)
itemtype <- rep('dich', nrow(a))
N <- 1000
dataset1 <- simdata(a, d, N, itemtype)
dataset2 <- simdata(a, d, N, itemtype, mu = .1, sigma = matrix(1.5))
dat <- rbind(dataset1, dataset2)
group <- c(rep('D1', N), rep('D2', N))
models <- mirt.model('F1 = 1-15')

mod_configural <- multipleGroup(dat, models, group = group)
group.1 <- extract.group(mod_configural, 1) #extract first group
summary(group.1)
plot(group.1, type = 'score')
}
}
\seealso{
\code{\link{extract.item}}
}
\keyword{extract}

