% Generated by roxygen2 (4.0.1): do not edit by hand
\name{imputeMissing}
\alias{imputeMissing}
\title{Imputing plausible data for missing values}
\usage{
imputeMissing(x, Theta, ...)
}
\arguments{
\item{x}{an estimated model x from the mirt package}

\item{Theta}{a matrix containing the estimates of the latent trait scores
(e.g., via \code{\link{fscores}})}

\item{...}{additional arguments to pass}
}
\description{
Given an estimated model from any of mirt's model fitting functions and an estimate of the
latent trait, impute plausible missing data values. Returns the original data in a
\code{data.frame} without any NA values.
}
\examples{
\dontrun{
dat <- expand.table(LSAT7)
(original <- mirt(dat, 1))
NAperson <- sample(1:nrow(dat), 20, replace = TRUE)
NAitem <- sample(1:ncol(dat), 20, replace = TRUE)
for(i in 1:20)
    dat[NAperson[i], NAitem[i]] <- NA
(mod <- mirt(dat, 1))
scores <- fscores(mod, method = 'MAP', scores.only = TRUE)

#re-estimate imputed dataset (good to do this multiple times and average over)
fulldata <- imputeMissing(mod, scores)
(fullmod <- mirt(fulldata, 1))

#with multipleGroup
group <- rep(c('group1', 'group2'), each=500)
mod2 <- multipleGroup(dat, 1, group)
fs <- fscores(mod2, full.scores=TRUE)
fulldata2 <- imputeMissing(mod2, fs)
}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
\keyword{impute}

