% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse}
\alias{collapse}
\alias{collapse.default}
\alias{collapse.data.frame}
\title{Collapse objects}
\usage{
collapse(x, sep, ...)

\method{collapse}{default}(x, sep = "", ..., .unique = FALSE,
  .sort = FALSE, .decreasing = FALSE)

\method{collapse}{data.frame}(x, sep = "", by = names(x), ...,
  .unique = FALSE, .sort = FALSE, .decreasing = FALSE, .unlist = FALSE,
  .sortby = FALSE)
}
\arguments{
\item{x}{Any R object.}

\item{sep}{A character string to separate value columns.
\code{NULL} retains a vector.}

\item{...}{Forwarded to or from other methods.}

\item{.unique}{Logical, return only unique values.}

\item{.sort}{Logical, sort the values.}

\item{.decreasing}{Logical, if sorting, then by decreasing values.}

\item{by}{Column names to split data frame by, before
applying collapse on each remaining column within each piece.
Using the default (all columns), then \code{unique(x)} is
returned. Columns can be specified by names or integer
with the column numbers. Using \code{0} or \code{NULL}
collapses all columns.}

\item{.unlist}{Logical, if value columns need to be unlisted
before collapsing.}

\item{.sortby}{Logical, sort the output on the \code{by} columns.
This applies ,
If \code{x} was a \code{data.table}, then the keys are set as
the \code{by} values.}
}
\description{
Collapse objects as in the \code{paste} function.
}
\details{
For the \code{data.frame} method, \code{x} is converted to a 
\code{data.table} before applying the piece- and column-wise collapses. If
the input is already inheriting from \code{data.table}, then the class is
retained.\cr
\code{.sortby} is causing \code{setkeyv(x, by)} to be applied to \code{x}
after converting to a \code{data.table}.
}
\examples{
#

### some data

set.seed(12)
s <- s2 <- sample(LETTERS[1:4], 9, replace = TRUE)
s2[1:2] <- rev(s2[1:2])
d <- data.frame(group = rep(letters[c(3,1,2)], each = 3), 
                value = s,
                level = factor(s2),
                stringsAsFactors = FALSE)

### collapse vectors

collapse(letters)
collapse(1:3)               # coerced to character
collapse(LETTERS[1:5], "-") # separated by '-'

### collapse data.frames

# by all columns (same as unique)
collapse(d)
# by a grouping column
collapse(d, by = 1)
# by multiple, but not all columns
collapse(d, by = c("group", "value"))
# return single row
collapse(d, by = 0)
# return single row, unique and sorted values
collapse(d, by = 0, .unique = TRUE, .sort = TRUE)

#
}
\author{
Sven E. Templer
}
