% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.censor}
\alias{md.censor}
\title{Censoring simulated survival data}
\usage{
md.censor(data, start, end, eventcolumns)
}
\arguments{
\item{data}{data.frame containig event times and covariates}

\item{start}{column name specifying start dates (left censoring)}

\item{end}{column name specifying end dates (right censoring)}

\item{eventcolumns}{vector of column names specifying a single event time or multiple event times (in case of competing risks)}
}
\value{
data.frame containing original data and columns time, maxtime and status
}
\description{
The md.censor function takes the data set simulated by the \code{\link{md.simulate}} and transforms it into 
a right censored sample by adding two columns to the original data set:\cr
 - time specifies the time to event or censoring, whichever comes first, specified in days and \cr
 - status specifies the censoring indicator and equals 0 if the individual is censored or <>0 in case of event.
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
  md.sex("sex", 0.5) + 
    md.dateuniform("birth", as.Date("1915-1-1"), as.Date("1930-1-1")) +
      md.dateuniform("start", as.Date("2000-1-1"), as.Date("2005-1-1")) +
        md.death("death", survexp.us, "sex", "birth", "start") +
          md.eval("age", "as.numeric(start - birth)/365.2425", 80, FALSE) + 
            md.exp("event", "start", c("age", "sex"), c(0.1, 2), 0.05/365.2425)
            
data = md.simulate(sim, 1000)
complete = md.censor(data, "start", as.Date("2010-1-1"), c("event", "death"))
}

}

