% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_in_classes.R
\name{impute_in_classes}
\alias{impute_in_classes}
\title{Impute in classes}
\usage{
impute_in_classes(
  ds,
  cols_class,
  FUN,
  breaks = Inf,
  use_quantiles = FALSE,
  min_objs_in_class = 1,
  min_obs_comp = 0,
  min_obs_per_col = 1,
  donor_limit = Inf,
  dl_type = "cols_seq",
  add_imputation_classes = FALSE,
  ...
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{cols_class}{Columns that are used for constructing the imputation
classes.}

\item{FUN}{An imputation function that is applied to impute the missing
values.}

\item{breaks}{Number of intervals / levels a column is broken into (see
\code{\link[=cut]{cut()}}, which is used internally for cutting numeric columns). If \code{breaks = Inf} (the default), every unique value of a column can be in a separate
class (if no other restrictions apply).}

\item{use_quantiles}{Should quantiles be used for cutting numeric vectors?
Normally, \code{\link[=cut]{cut()}} divides the range of an vector into equal spaced
intervals. If \code{use_quantiles = TRUE}, the classes will be of roughly equal
content.}

\item{min_objs_in_class}{Minimum number of objects (rows) in an imputation class.}

\item{min_obs_comp}{Minimum number of completely observed objects (rows) in an
imputation class.}

\item{min_obs_per_col}{Minimum number of observed values in every column of
an imputation class.}

\item{donor_limit}{Minimum odds between incomplete and complete values in a
column, if \code{dl_type = cols_seq}. If \code{dl_type = sim_comp}, minimum odds
between incomplete and complete rows.}

\item{dl_type}{See \code{donor_limit}.}

\item{add_imputation_classes}{Should imputation classes be added as
attributes to the imputed dataset?}

\item{...}{Arguments passed to \code{FUN}.}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Apply an imputation function inside imputation classes
}
\details{
Imputation classes (sometimes also called adjustment cells) are
build using cross-validation of all \code{cols_class}. The classes are
collapsed, if they do not satisfy all of the criteria defined by
\code{min_objs_in_class}, \code{min_obs_comp}, \code{min_obs_per_col} and \code{donor_limit}.
Collapsing starts from the last value of \code{cols_class}. Internally, a mixture
of collapsing and early stopping is used for the construction of the
classes.
}
\examples{
# Mean imputation in classes
impute_in_classes(data.frame(X = 1:5, Y = c(NA, 12:15)), "X",
  impute_mean,
  min_obs_per_col = 2
)
}
\references{
Andridge, R.R. and Little, R.J.A. (2010), A Review of Hot Deck
Imputation for Survey Non-response. International Statistical Review, 78:
40-64. doi:10.1111/j.1751-5823.2010.00103.x
}
