% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.missRanger}
\alias{predict.missRanger}
\title{Predict Method}
\usage{
\method{predict}{missRanger}(
  object,
  newdata,
  pmm.k = object$pmm.k,
  iter = 4L,
  num.threads = NULL,
  seed = NULL,
  verbose = 1L,
  ...
)
}
\arguments{
\item{object}{'missRanger' object.}

\item{newdata}{A \code{data.frame} with missing values to impute.}

\item{pmm.k}{Number of candidate predictions of the original dataset
for predictive mean matching (PMM). By default the same value as during fitting.}

\item{iter}{Number of iterations for "hard case" rows. 0 for univariate imputation.}

\item{num.threads}{Number of threads used by ranger's predict function.
The default \code{NULL} uses all threads.}

\item{seed}{Integer seed used for initial univariate imputation and PMM.}

\item{verbose}{Should info be printed? (1 = yes/default, 0 for no).}

\item{...}{Passed to the predict function of ranger.}
}
\description{
Impute missing values on \code{newdata} based on an object of class "missRanger".

For multivariate imputation, use \code{missRanger(..., keep_forests = TRUE)}.
For univariate imputation, no forests are required.
This can be enforced by \code{predict(..., iter = 0)} or via \code{missRanger(. ~ 1, ...)}.

Note that out-of-sample imputation works best for rows in \code{newdata} with only one
missing value (counting only missings in variables used as covariates
in random forests). We call this the "easy case". In the "hard case",
even multiple iterations (set by \code{iter}) can lead to unsatisfactory results.
}
\details{
The out-of-sample algorithm works as follows:
\enumerate{
\item Impute univariately all relevant columns by randomly drawing values
from the original unimputed data. This step will only impact "hard case" rows.
\item Replace univariate imputations by predictions of random forests. This is done
sequentially over variables, where the variables are sorted to minimize the impact
of univariate imputations. Optionally, this is followed by predictive mean matching (PMM).
\item Repeat Step 2 for "hard case" rows multiple times.
}
}
\examples{
iris2 <- generateNA(iris, seed = 20, p = c(Sepal.Length = 0.2, Species = 0.1))
imp <- missRanger(iris2, pmm.k = 5, num.trees = 100, keep_forests = TRUE, seed = 2)
predict(imp, head(iris2), seed = 3)
}
