% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.missingHE.R
\name{coef.missingHE}
\alias{coef.missingHE}
\title{Extract regression coefficient estimates from objects in the class \code{missingHE}}
\usage{
\method{coef}{missingHE}(object, prob = c(0.025, 0.975), random = FALSE, digits = 3, ...)
}
\arguments{
\item{object}{A \code{missingHE} object containing the results of the Bayesian modelling and the economic evaluation}

\item{prob}{A numeric vector of probabilities within the range (0,1), representing the upper and lower
CI sample quantiles to be calculated and returned for the estimates.}

\item{random}{Logical. If \code{random} is \code{TRUE}, the estimates of the random effects parameters are printed, when available.}

\item{digits}{Number of digits to be displayed for each estimate.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Prints a table with some summary statistics, including posterior mean, standard deviation and lower and upper quantiles based on the
values specified in \code{prob}, for the posterior distributions of the regression coefficients of the effects and costs models run using the 
function \code{selection}, \code{pattern} or \code{hurdle}.
}
\description{
Produces a table printout with summary statistics for the regression coefficients of the health economic evaluation probabilistic model
run using the function \code{\link{selection}}, \code{\link{pattern}} or \code{\link{hurdle}}.
}
\examples{
 
# For examples see the function \code{\link{selection}}, 
# \code{\link{pattern}} or \code{\link{hurdle}}
# 
# 
}
\seealso{
\code{\link{selection}} \code{\link{pattern}} \code{\link{hurdle}} \code{\link{diagnostic}} \code{\link{plot.missingHE}}
}
\author{
Andrea Gabrio
}
