% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.lpa.R
\name{mplus.lpa}
\alias{mplus.lpa}
\title{Mplus Model Specification for Latent Profile Analysis}
\usage{
mplus.lpa(x, ind = NULL, cluster = NULL,
          folder = c("A_Invariant-Theta_Diagonal-Sigma",
                     "B_Varying-Theta_Diagonal-Sigma",
                     "C_Invariant-Theta_Invariant-Unrestrictred-Sigma",
                     "D_Invariant-Theta_Varying-Unrestricted-Sigma",
                     "E_Varying-Theta_Invariant-Unrestricted-Sigma",
                     "F_Varying-Theta_Varying-Unrestricted-Sigma"),
          file = "Data_LPA.dat", write = c("all", "folder", "data", "input"),
          missing = -99, classes = 6, estimator = "MLR", starts = c(500, 100),
          stiterations = 50, lrtbootstrap = 1000, lrtstarts = c(0, 0, 100, 50),
          processors = 8,  output = c("all", "SVALUES", "TECH7", "TECH8",
                                      "TECH11", "TECH14"),
          run.mplus = FALSE, Mplus = "Mplus",
          replace = c("always", "never", "modifiedDate"), check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame. Note that all variable names must
be no longer than 8 character.}

\item{ind}{a character vector indicating the variables names of the
latent profile indicators in \code{x}.}

\item{cluster}{a character string indicating the cluster variable in the
matrix or data frame specified in \code{x} representing the
nested grouping structure for computing cluster-robust
standard errors. Note that specifying a cluster variables
does not have any effect on the information criteria, but
for the Vuong-Lo-Mendell-Rubin likelihood ratio test of model fit.}

\item{folder}{a character vector with six character strings for specifying
the names of the six folder representing different
variance-covariance structures.}

\item{file}{a character string naming the Mplus file with or without
the file extension '.dat', e.g., \code{"Data_LPA.dat"} (default)
or \code{"Data_LPA"}.}

\item{write}{a character string or character vector indicating whether
to create the six folders specified in the argument \code{folder}
(\code{"folder"}), to write the matrix or data frame specified
in \code{x} into a Mplus data file (\code{"data"}), and
write the Mplus input files into the six folders specified
in the argument \code{folder}  (\code{"input"}). By default,
the function creates the folders, writes the Mplus data file,
and writes the Mplus input files into the folders.}

\item{missing}{a numeric value or character string representing missing
values (\code{NA}) in the Mplus data set. This values or
character string will be specified in the Mplus input file
as \code{MISSING IS ALL(missing)}. By default, \code{-99}
is used to represent missing values.}

\item{classes}{an integer value specifying the maximum number of profiles
for the latent profile analysis. By default, a LPA with a
maximum of 6 profiles are specified (i.e., \emph{k} = 1
to \emph{k} = 6).}

\item{estimator}{a character string for specifying the \code{ESTIMATOR}
option in Mplus. By default, the estimator \code{"MLR"} is
used.}

\item{starts}{a vector with two integer values for specifying the
\code{STARTS} option in Mplus. The first number represents
the number of random sets of starting values to generate
in the initial stage and the second number represents the
optimizations to use in the final stage. By default, 500
random sets of starting values are generated and 100
optimizations are carried out in the final stage.}

\item{stiterations}{an integer value specifying the \code{STITERATIONS} option
in Mplus. The numeric value represents the maximum number
of iterations allowed in the initial stage. By default,
50 iterations are requested.}

\item{lrtbootstrap}{an integer value for specifying the \code{LRTBOOTSTRAP} option
in Mplus when reqeuesting a parametric bootstrapped likelihood
ratio test (i.e., \code{output = "TECH14"}). The value
represents the number of bootstrap draws to be used in
estimating the \emph{p}-value of the parametric bootstrapped
likelihood ratio test. By default, 1000 bootstrap draws are
requested.}

\item{lrtstarts}{a vector with four integer values for specifying the
\code{LRTSTARTS} option in Mplus when reqeuesting a parametric
bootstrapped likelihood ratio test (i.e., \code{output = "TECH14"}).
The values specify the number of starting values to use in
the initial stage and the number of optimizations to use
in the final stage for the \code{k - 1} and \code{k} profile
model when the data generated by bootstrap draws are analyzed.
By default, 0 random sets of starting values in the initial
stage and 0 optimizations in the final stage are used for
the \code{k - 1} profile model and 100 random sets of starting
values in  the initial stage and 50 optimizations in the
final stage are used for the \code{k} profile model.}

\item{processors}{an integer value for specifying the \code{PROCESSORS} option
in Mplus. The value specifies the number of processors
and threads to be used for parallel computing to increase
computational speed. By default, 8 processors and threads
are used for parallel computing.}

\item{output}{a character string or character vector specifying the \code{TECH}
options in the \code{OUTPUT} section in Mplus, i.e., code{SVALUES}
to request input statements that contain parameter estimates
from the analysis, \code{TECH7} to request sample statistics
for each profile using raw data weighted by the estimated
posterior probabilities for each profile, \code{TECH8} to
request the optimization history in estimating the model,
\code{TECH11} to request the Vuong-Lo-Mendell-Rubin
likelihood ratio test of model fit, and \code{TECH14} to
request a parametric bootstrapped likelihood ratio test.
By default, \code{SVALUES} and \code{TECH11} are requested.
Note that \code{TECH11} is only available for the \code{MLR}
estimator.}

\item{run.mplus}{logical: if \code{TRUE}, all models in the folders specified
in the argument \code{folder} are estimated by using the
\code{run.mplus} function in the R package \code{misty}.}

\item{Mplus}{a character string for specifying the name or path of the
Mplus executable to be used for running models. This covers
situations where Mplus is not in the system's path, or where
one wants to test different versions of the Mplus program.
Note that there is no need to specify this argument for most
users since it has intelligent defaults.}

\item{replace}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modifiedDate"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{matrix or data frame specified in the argument x}
\item{\code{args}}{specification of function arguments}
\item{\code{result}}{list with six entries for each of the variance-covariance
                     structures and the Mplus inputs based on different number
                     of profiles}
}
\description{
This function writes Mplus input files for conducting latent profile analysis
(LPA) based on six different variance-covariance structures. By default, the
function creates folders in the current working directory for each of the six
sets of analysis, writes Mplus input files for conducting LPA with \emph{k} = 1
to \emph{k} = 6 profiles into these folders, and writes the matrix or data frame
specified in \code{x} into a Mplus data file in the current working directory.
Optionally, all models can be estimated by setting the argument \code{run.mplus}
to \code{TRUE}.
}
\details{
Latent profile analysis is a model-based clustering and classification method
used to identify qualitatively different classes of observations which are
unknown and must be inferred from the data. The within-profile variance-covariance
structures represt different assumptions regarding the variance and covariance
of the indicator variables both within and between latent profiles. As the best
within-profile variance-covariance structure is not known a priori, all of the
different structures must be tested to identify the best model (Masyn, 2013).
This function specifies six different six different variance-covariance structures
labeled A to F (see Table 1 in Patterer et al, 2023):
\describe{
\item{\strong{Model A}}{The within-profile variance is constrained to be
profile-invariant and covariances are constrained to be 0 in all profiles
(i.e., equal variances across profiles and no covariances among indicator
variables).}
\item{\strong{Model B}}{The within-profile variance profile-varying and covariances
are constrained to be 0 in all profiles (i.e., unequal variances across profiles
and no covariances among indicator variables).}
\item{\strong{Model C}}{The within-profile variance is constrained to be
profile-invariant and covariances are constrained to be equal in all profiles
(i.e., equal variances and covariances across profiles).}
\item{\strong{Model D}}{The within-profile variance is constrained to be
profile-invariant and covariances are profile-varying (i.e., equal variances
across profiles and unequal covariances across profiles).}
\item{\strong{Model E}}{The within-profile variances are profile-varying and
covariances are constrained to be equal in all profiles (i.e., unequal variances
across profiles and equal covariances across profiles).}
\item{\strong{Model F}}{The within-class variance and covariances both
profile-varying (i.e., unequal variances and covariances across profiles).}
}
}
\examples{
\dontrun{
# Load data set "HolzingerSwineford1939" in the lavaan package
data("HolzingerSwineford1939", package = "lavaan")

# LPA with k = 1 to k = 8 profiles
# Input statements that contain parameter estimates
# Lo-Mendell-Rubin LRT and bootstrapped LRT
mplus.lpa(HolzingerSwineford1939, ind = c("x1", "x2", "x3", "x4"),
          classes = 8, output = c("SVALUES", "TECH11", "TECH14"))
}
}
\references{
Masyn, K. E. (2013). Latent class analysis and finite mixture modeling. In T. D.
Little (Ed.), \emph{The Oxford handbook of quantitative methods: Statistical analysis}
(pp. 551–611). Oxford University Press.

Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.

Patterer, A. S., Yanagida, T., Kühnel, J., & Korunka, C. (2023). Daily receiving
and providing of social support at work: Identifying support exchange patterns
in hierarchical data. \emph{Journal of Work and Organizational Psychology, 32}(4),
489-505. https://doi.org/10.1080/1359432X.2023.2177537
}
\seealso{
\code{\link{result.lpa}}, \code{\link{run.mplus}}, \code{\link{read.mplus}},
\code{\link{write.mplus}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
