% Generated by roxygen2 (4.0.2): do not edit by hand
\name{computeBIC}
\alias{computeBIC}
\title{Compute the approximate BIC}
\usage{
computeBIC(model)
}
\arguments{
\item{model}{the \code{mixedMemModel} object for which the BIC will be calculated}
}
\value{
the approximate BIC value
}
\description{
Computes the approximate BIC of a given \code{mixedMemModel}, where the lower bound on the log-likelihood
(also called ELBO) is used instead of the intractable true log-likelihood.
}
\details{
\eqn{BIC = -2 ELBO + p \log(Total)}

where p is the number of estimated parameters and Total is the number of individuals in
the sample.

This BIC model selection criteria is used
in Erosheva (2007). When counting the number of fitted parameters, we only include the
hyperparameters \eqn{\theta} and \eqn{\alpha} and omit the variational parameters \eqn{\phi} and \eqn{\delta}.
}
\references{
Erosheva, E. A., Fienberg, S. E., & Joutard, C. (2007). Describing disability through individual-level mixture models for multivariate binary data. The annals of applied statistics, 1(2), 346.
}

