% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rmixedMem}
\alias{rmixedMem}
\title{Simulate Mixed Membership Data}
\usage{
rmixedMem(Total, J, Rj, Nijr, K, Vj, dist, theta, alpha, lambda = NULL)
}
\arguments{
\item{Total}{the number of individuals in the sample}

\item{J}{the number of variables observed on each individual}

\item{Rj}{vector of length J specifying the number of repeated measurements
for each variable}

\item{Nijr}{an array of dimension (Total, J, max(Rj)) indicating the number
of ranking levels for each replication. For multinomial and bernoulli
variables, Nijr[i,j,r] = 1. For rank variables, Nijr[i,j,r] indicates the
number of candidates ranked.}

\item{K}{the number of latent sub-populations}

\item{Vj}{vector of length J specifying the number of possible candidates
for each variable. For a bernoulli variable Vj[j] = 1. For a multinomial
 or rank variable, Vj[j] is the number of possible categories/candidates}

\item{dist}{vector of length J specifying variable types. Options are
"bernoulli", "multinomial" or "rank" corresponing to the distributions
 of the observed variables}

\item{theta}{array of dimension (J,K,max(Vj)) which governs the variable
distributions. theta[j,k,] is the parameter for how sub-population k responds
to variable j. If the number of candidates differs across variables, any
unusued portions of theta should be 0.}

\item{alpha}{vector of length K which is the hyperparameter for Dirichlet
membership distribution}

\item{lambda}{a matrix containing the group membership for each individual. If the lambda
argument is not specified, the lambda's will be automatically sampled from a Dirichlet(alpha)}
}
\value{
A list containing a three items. A matrix of group memberships (lambda),
an array of context indicators (Z) and an array of observations (obs)
}
\description{
Simulate data from the mixed membership generative model
}
\details{
Given the parameters and dimensions of a mixed membership model, the function
returns a random sample of observed values (X), context indicators (Z) and group memberships (lambda).
}

