% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFMortGear}
\alias{mizerFMortGear}
\title{Get the fishing mortality by time, gear, species and size needed to project
standard mizer model}
\usage{
mizerFMortGear(params, effort, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{effort}{A vector with the effort for each fishing gear.}

\item{...}{Optional arguments for rate functions.}
}
\value{
An three dimensional array (gear x species x size) with the
fishing mortality
}
\description{
Calculates the fishing mortality rate \eqn{F_{g,i,w}} by gear, species and
size at each time step in the \code{effort} argument (in units 1/year).
Used by the \code{project} function to perform simulations.
}
\note{
Here: fishing mortality = catchability x selectivity x effort.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
