% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parms.R
\name{parms}
\alias{parms}
\alias{parms.mkinfit}
\alias{parms.mmkin}
\alias{parms.multistart}
\title{Extract model parameters}
\usage{
parms(object, ...)

\method{parms}{mkinfit}(object, transformed = FALSE, errparms = TRUE, ...)

\method{parms}{mmkin}(object, transformed = FALSE, errparms = TRUE, ...)

\method{parms}{multistart}(object, exclude_failed = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{\dots}{Not used}

\item{transformed}{Should the parameters be returned as used internally
during the optimisation?}

\item{errparms}{Should the error model parameters be returned
in addition to the degradation parameters?}

\item{exclude_failed}{For \link{multistart} objects, should rows for failed fits
be removed from the returned parameter matrix?}
}
\value{
Depending on the object, a numeric vector of fitted model parameters,
a matrix (e.g. for mmkin row objects), or a list of matrices (e.g. for
mmkin objects with more than one row).
}
\description{
This function returns degradation model parameters as well as error
model parameters per default, in order to avoid working with a fitted model
without considering the error structure that was assumed for the fit.
}
\examples{
# mkinfit objects
fit <- mkinfit("SFO", FOCUS_2006_C, quiet = TRUE)
parms(fit)
parms(fit, transformed = TRUE)

# mmkin objects
ds <- lapply(experimental_data_for_UBA_2019[6:10],
 function(x) subset(x$data[c("name", "time", "value")]))
names(ds) <- paste("Dataset", 6:10)
\dontrun{
fits <- mmkin(c("SFO", "FOMC", "DFOP"), ds, quiet = TRUE, cores = 1)
parms(fits["SFO", ])
parms(fits[, 2])
parms(fits)
parms(fits, transformed = TRUE)
}
}
\seealso{
\link{saem}, \link{multistart}
}
