% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_effect.R
\name{design_effect}
\alias{design_effect}
\title{Design Effect}
\usage{
design_effect(x, median = FALSE)
}
\arguments{
\item{x}{model produced using the \code{lme4::lmer()} function. This is an object of class \code{merMod} and subclass \code{lmerMod}.}

\item{median}{Boolean argument (TRUE/FALSE) to use the median cluster size to compute the design effect. By default, the average cluster size is used.}
}
\value{
a data frame containing the cluster variable, number of clusters, average (or median) cluster size, intraclass correlation, and the design effect
}
\description{
The design effect quantifies the degree a sample deviates from a simple random sample. In the multilevel modeling context, this can be used to determine whether clustering will bias standard errors and whether the assumption of independence is held. Thus, it can help determine whether multilevel modeling is appropriate for a given data set. The calculations are based on (Hox et al., 2018) and uses the \code{mlmhelpr:icc} function. A rule of thumb is that design effects smaller than 2 may indicate multilevel modeling is not necessary; however, this is dependent on cluster size and other factors (Lai et al., 2015).

\strong{Note}: For models with random slopes, it is generally advised to interpret with caution. According to Kreft and De Leeuw (1998), "The concept of intra-class correlation is based on a model with a random intercept only. No unique intra-class correlation can be calculated when a random slope is present in the model" (p. 63). Since the intra-class correlation is part of the design effect calculation, caution is advised when interpreting models with random slopes.
}
\examples{
fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id),
data=hsb, REML=TRUE)

design_effect(fit)
}
\references{
{
\insertRef{hox2018}{mlmhelpr}
}

{
\insertRef{lai2015}{mlmhelpr}
}

{
\insertRef{kreft1998}{mlmhelpr}
}
}
