/**
 * @file src/adaboost.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R adaboost binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/adaboost/adaboost_main.cpp>

// [[Rcpp::export]]
void adaboost_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a AdaBoostModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamAdaBoostModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<AdaBoostModel>) IO::GetParam<AdaBoostModel*>(paramName));
}

// Set the pointer to a AdaBoostModel parameter.
// [[Rcpp::export]]
void IO_SetParamAdaBoostModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<AdaBoostModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<AdaBoostModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a AdaBoostModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeAdaBoostModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("AdaBoostModel",
          *Rcpp::as<Rcpp::XPtr<AdaBoostModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "AdaBoostModel";
  return raw_vec;
}

// Deserialize a AdaBoostModel pointer.
// [[Rcpp::export]]
SEXP DeserializeAdaBoostModelPtr(Rcpp::RawVector str)
{
  AdaBoostModel* ptr = new AdaBoostModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("AdaBoostModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<AdaBoostModel>)ptr);
}


