/**
 * @file src/fastmks.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R fastmks binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/fastmks/fastmks_main.cpp>

// [[Rcpp::export]]
void fastmks_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a FastMKSModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamFastMKSModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<FastMKSModel>) IO::GetParam<FastMKSModel*>(paramName));
}

// Set the pointer to a FastMKSModel parameter.
// [[Rcpp::export]]
void IO_SetParamFastMKSModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<FastMKSModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<FastMKSModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a FastMKSModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeFastMKSModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("FastMKSModel",
          *Rcpp::as<Rcpp::XPtr<FastMKSModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "FastMKSModel";
  return raw_vec;
}

// Deserialize a FastMKSModel pointer.
// [[Rcpp::export]]
SEXP DeserializeFastMKSModelPtr(Rcpp::RawVector str)
{
  FastMKSModel* ptr = new FastMKSModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("FastMKSModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<FastMKSModel>)ptr);
}


