% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction_classif.R
\name{as_prediction_classif}
\alias{as_prediction_classif}
\alias{as_prediction_classif.PredictionClassif}
\alias{as_prediction_classif.data.frame}
\title{Convert to a Classification Prediction}
\usage{
as_prediction_classif(x, ...)

\method{as_prediction_classif}{PredictionClassif}(x, ...)

\method{as_prediction_classif}{data.frame}(x, ...)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments.}
}
\value{
\link{PredictionClassif}.
}
\description{
Convert object to a \link{PredictionClassif}.
}
\examples{
# create a prediction object
task = tsk("penguins")
learner = lrn("classif.rpart", predict_type = "prob")
learner$train(task)
p = learner$predict(task)

# convert to a data.table
tab = as.data.table(p)

# convert back to a Prediction
as_prediction_classif(tab)

# split data.table into a list of data.tables
tabs = split(tab, tab$truth)

# convert back to list of predictions
preds = lapply(tabs, as_prediction_classif)

# calculate performance in each group
sapply(preds, function(p) p$score())
}
