% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSimple.R
\name{mlr_measures_regr.pbias}
\alias{mlr_measures_regr.pbias}
\title{Percent Bias}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
The Percent Bias is defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n w_i \frac{\left( t_i - r_i \right)}{\left| t_i \right|}.
}{
  weighted.mean((t - r) / abs(t), w).
}
Good predictions score close to 0.
}
\note{
The score function calls \code{\link[mlr3measures:pbias]{mlr3measures::pbias()}} from package \CRANpkg{mlr3measures}.

If the measure is undefined for the input, \code{NaN} is returned.
This can be customized by setting the field \code{na_value}.
}
\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:\preformatted{mlr_measures$get("regr.pbias")
msr("regr.pbias")
}
}

\section{Parameters}{

Empty ParamSet
}

\section{Meta Information}{


\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{(-\infty, \infty)}{(-Inf, Inf)}
\item Minimize: \code{NA}
\item Required prediction: \code{response}
}

}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.

Other regression measures: 
\code{\link{mlr_measures_regr.bias}},
\code{\link{mlr_measures_regr.ktau}},
\code{\link{mlr_measures_regr.mae}},
\code{\link{mlr_measures_regr.mape}},
\code{\link{mlr_measures_regr.maxae}},
\code{\link{mlr_measures_regr.medae}},
\code{\link{mlr_measures_regr.medse}},
\code{\link{mlr_measures_regr.mse}},
\code{\link{mlr_measures_regr.msle}},
\code{\link{mlr_measures_regr.rae}},
\code{\link{mlr_measures_regr.rmse}},
\code{\link{mlr_measures_regr.rmsle}},
\code{\link{mlr_measures_regr.rrse}},
\code{\link{mlr_measures_regr.rse}},
\code{\link{mlr_measures_regr.rsq}},
\code{\link{mlr_measures_regr.sae}},
\code{\link{mlr_measures_regr.smape}},
\code{\link{mlr_measures_regr.srho}},
\code{\link{mlr_measures_regr.sse}}
}
\concept{regression measures}
