% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probregr_compose.R
\name{probregr_compose}
\alias{probregr_compose}
\title{Create a Distr Predict Type for Regression Learners}
\usage{
probregr_compose(learner, dist = "Normal", param_vals = list())
}
\arguments{
\item{learner}{\link{LearnerSurv} object for which a \code{distr} is composed.}

\item{dist}{Location-scale distribution to use for composition. Current possibilities are
\verb{"Cauchy", "Gumbel", "Laplace", "Logistic", "Normal} (default).}

\item{param_vals}{Additional parameters to pass to the \code{learner}.}
}
\value{
\link[mlr3pipelines:GraphLearner]{mlr3pipelines::GraphLearner}
}
\description{
This is a wrapper around the \link{PipeOpProbregrCompositor} pipe operation, which
simplifies graph creation.
}
\details{
For full details see \link{PipeOpProbregrCompositor}.
}
\examples{
\dontrun{
library(mlr3)
library(mlr3pipelines)

task = tsk("boston_housing")
feat_distr = probregr_compose(
  learner = lrn("regr.featureless", predict_type = "se"),
  dist = "Logistic")
resample(task, feat_distr, rsmp("cv", folds = 2))$predictions()
}
}
