% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_classif_st.R, R/as_task_regr_st.R
\name{as_task_regr_st.TaskClassifST}
\alias{as_task_regr_st.TaskClassifST}
\alias{as_task_regr_st}
\alias{as_task_regr_st.TaskRegrST}
\alias{as_task_regr_st.data.frame}
\alias{as_task_regr_st.DataBackend}
\alias{as_task_regr_st.sf}
\title{Convert to a Spatiotemporal Regression Task}
\usage{
\method{as_task_regr_st}{TaskClassifST}(
  x,
  target = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)

as_task_regr_st(x, ...)

\method{as_task_regr_st}{TaskRegrST}(x, clone = FALSE, ...)

\method{as_task_regr_st}{data.frame}(
  x,
  target,
  id = deparse(substitute(x)),
  coordinate_names,
  crs = NA_character_,
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)

\method{as_task_regr_st}{DataBackend}(
  x,
  target,
  id = deparse(substitute(x)),
  positive = NULL,
  coordinate_names,
  crs,
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)

\method{as_task_regr_st}{sf}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)

\method{as_task_regr_st}{TaskClassifST}(
  x,
  target = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{drop_original_target}{(\code{logical(1)})\cr
If \code{FALSE} (default), the original target is added as a feature.
Otherwise the original target is dropped.}

\item{drop_levels}{(\code{logical(1)})\cr
If \code{TRUE} (default), unused levels of the new target variable are dropped.}

\item{...}{(any)\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of the data argument.}

\item{coordinate_names}{(\code{character(1)})\cr
The column names of the coordinates in the data.}

\item{crs}{(\code{character(1)})\cr
Coordinate reference system.
WKT2 or EPSG string.}

\item{coords_as_features}{(\code{logical(1)})\cr
If \code{TRUE}, coordinates are used as features.
This is a shortcut for
\code{task$set_col_roles(c("x", "y"), role = "feature")} with the assumption
that the coordinates in the data are named \code{"x"} and \code{"y"}.}

\item{label}{(\code{character(1)})\cr
Label for the new instance. Shown in \code{as.data.table(mlr_tasks)}.}

\item{positive}{(\code{character(1)})\cr
Only for binary classification: Name of the positive class.
The levels of the target columns are reordered accordingly, so that the
first element of \verb{$class_names} is the positive class, and the second
element is the negative class.}
}
\value{
\link{TaskRegrST}
}
\description{
Convert object to a \link{TaskRegrST}.

This is a S3 generic, specialized for at least the following objects:
\enumerate{
\item \link{TaskRegrST}: Ensure the identity.
\item \code{\link[=data.frame]{data.frame()}} and \link{DataBackend}: Provides an alternative to the
constructor of \link{TaskRegrST}.
\item \link[sf:sf]{sf::sf}: Extracts spatial meta data before construction.
\item \link{TaskClassif}: Calls \code{\link[=convert_task]{convert_task()}}.
}
}
\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf"), quietly = TRUE)) {
  library("mlr3")
  data("cookfarm_mlr3", package = "mlr3spatiotempcv")

  # data.frame
  as_task_regr_st(cookfarm_mlr3, target = "PHIHOX",
    coords_as_features = FALSE, crs = 26911,
    coordinate_names = c("x", "y"))

  # sf
  cookfarm_sf = sf::st_as_sf(cookfarm_mlr3, coords = c("x", "y"), crs = 26911)
  as_task_regr_st(cookfarm_sf, target = "PHIHOX")
}
}
}
