% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_cimrob.R
\name{process_results}
\alias{process_results}
\title{Process Cluster-Adjusted Robust Inference Results}
\usage{
process_results(results, ind_variables, ci.level, drop, return.vcv)
}
\arguments{
\item{results}{A list of results from cluster-specific model fittings.}

\item{ind_variables}{A vector of independent variable names for which the
results are computed.}

\item{ci.level}{Confidence level for the confidence intervals.}

\item{drop}{Logical; if TRUE, clusters with failed model fits are omitted
from the results.}

\item{return.vcv}{Logical; if TRUE, returns the variance-covariance matrix of
the cluster-averaged coefficients.}
}
\value{
A list containing the following elements:
\describe{
\item{p.values}{A matrix of p-values for each independent variable.}
\item{ci}{A matrix with the lower and upper bounds of the confidence intervals
for each independent variable.}
\item{vcv.hat}{The variance-covariance matrix of the cluster-averaged
coefficients, returned if \code{return.vcv} is TRUE.}
\item{beta.bar}{The cluster-averaged coefficients, returned if \code{return.vcv}
is TRUE.}
}
}
\description{
This internal function processes results from cluster-specific model fittings
for cluster-robust inference functions. It combines results, computes
variance-covariance matrix, standard errors, t-statistics, p-values, and
confidence intervals for each independent variable.
}
\details{
Workflow defined in clusterSEs::cluster.im.glm() function.
}
\keyword{internal}
