% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmibain.R
\name{mmibain}
\alias{mmibain}
\title{mmibain Shiny App}
\usage{
mmibain()
}
\value{
This function returns a running instance of the Shiny app.
Interact with the app through the browser or the RStudio Viewer pane.
}
\description{
The user can upload CSV data; choose a model engine (lm, t_test,
lavaan); specify the formula, variables, or model; and provide additional
arguments. Once the model is fitted, the app allows for setting up hypotheses
for evaluation. Upon running the analysis, it displays the results of the
Bayesian Informative Hypotheses Evaluation.
}
\details{
This function launches a Shiny app that facilitates a user-friendly interface
for setting up and running a Bayesian Informative Hypotheses Evaluation using
the \code{bain} package.

The app's UI consists of a sidebar for user inputs and a main panel
for displaying available variables, model terms, and analysis results. The app
relies on the \code{bain} package for analysis.
}
\section{UI Components}{

\itemize{
\item Data upload (CSV format).
\item Engine selection (lm, t_test, lavaan).
\item Model input based on chosen engine.
\item Additional arguments for statistical model function.
\item Action button to fit the model.
\item Hypotheses input.
\item Fraction input for the \code{bain} fraction parameter.
\item Option to evaluate hypotheses with respect to standardized regression
coefficients.
\item Confidence interval input.
\item Seed input for reproducibility.
\item Action button to run the Bayesian Informative Hypotheses Evaluation.
}
}

\examples{
if(interactive()){
  mmibain()
}

}
\references{
Hoijtink, H., Mulder, J., van Lissa, C., & Gu, X. (2019). A
tutorial on testing hypotheses using the Bayes factor. Psychological methods,
24(5), 539–556. https://doi.org/10.1037/met0000201
}
\seealso{
\code{\link[bain]{bain}}
}
