% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Paket_alle_Funktionen_Basis_v01_1-8Feb2018.R
\name{geem2}
\alias{geem2}
\title{Fit Generalized Estimating Equation Models}
\usage{
geem2(formula, id, waves = NULL, data = parent.frame(), family = gaussian,
  corstr = "independence", Mv = 1, weights = NULL, corr.mat = NULL,
  init.beta = NULL, init.alpha = NULL, init.phi = 1, scale.fix = FALSE,
  nodummy = FALSE, sandwich = TRUE, useP = TRUE, maxit = 20,
  tol = 1e-05, restriction = NULL, conv.criterion = c("ratio",
  "difference"))
}
\arguments{
\item{formula}{a formula expression similar to that for \code{\link[stats]{glm}}, of the form \code{response~predictors}. An offset is allowed, as in glm.}

\item{id}{a vector identifying the clusters. By default, data are assumed to be sorted such that observations in a cluster are in consecutive rows and higher
numbered rows in a cluster are assumed to be later. If \code{NULL}, then each observation is assigned its own cluster.}

\item{waves}{an integer vector identifying components of a cluster. For example, this could be a time ordering. If integers are skipped within a cluster,
then dummy rows with weight 0 are added in an attempt to preserve the correlation structure (except if \code{corstr = "exchangeable"} or \code{"independent"}).
This can be skipped by setting \code{nodummy=TRUE}.}

\item{data}{an optional data frame containing the variables in the model.}

\item{family}{will determine the link and variance functions. The argument can be one of three options: a family object, a character string, or a list of functions. 
For more information on how to use family objects, see \code{\link[stats]{family}}. If the supplied argument is a character string, then the string should
correspond to one of the family objects.
In order to define a link function, a list must be created with the components \code{(LinkFun, VarFun, InvLink, InvLinkDeriv)}, all of which are vectorized functions.
If the components in the list are not named as \code{(LinkFun, VarFun, InvLink, InvLinkDeriv)}, then \code{geem2} assumes that the functions are given in that order.
\code{LinkFun} and \code{VarFun} are the link and variance functions. \code{InvLink} and \code{InvLinkDeriv} are the inverse of the link function and the derivative
of the inverse of the link function and so are decided by the choice of the link function.}

\item{corstr}{a character string specifying the correlation structure. Allowed structures are: \code{"independence", "exchangeable", "ar1", "m-dependent", "unstructured", "fixed"},
and \code{"userdefined"}. Any unique substring may be supplied. If \code{"fixed"} or \code{"userdefined"}, then \code{corr.mat} must be specified. If \code{"m-dependent"},
then \code{Mv} is relevant.}

\item{Mv}{for \code{"m-dependent"}, the value for \code{m}.}

\item{weights}{A vector of weights for each observation. If an observation has weight 0, it is excluded from the calculations of any parameters.
Observations with a \code{NA} anywhere (even in variables not included in the model) will be assigned a weight of 0. 
Note that weights are defined differently in \code{geem2} and \code{geem}, see details.}

\item{corr.mat}{the correlation matrix for \code{"fixed"}. Matrix should be symmetric with dimensions >= the maximum cluster size.
If the correlation structure is \code{"userdefined"}, then this is a matrix describing which correlations are the same.}

\item{init.beta}{an optional vector with the initial values of beta. If not specified, then the intercept will be set to \code{InvLink(mean(response))}.
\code{init.beta} must be specified if not using an intercept.}

\item{init.alpha}{an optional scalar or vector giving the initial values for the correlation. If provided along with \code{Mv>1} or unstructured correlation,
then the user must ensure that the vector is of the appropriate length.}

\item{init.phi}{an optional initial overdispersion parameter. If not supplied, initialized to 1.}

\item{scale.fix}{if set to \code{TRUE}, then the scale parameter is fixed at the value of init.phi.}

\item{nodummy}{if set to \code{TRUE}, then dummy rows will not be added based on the values in waves.}

\item{sandwich}{if \code{TRUE}, calculate robust variance.}

\item{useP}{if set to \code{FALSE}, do not use the n-p correction for dispersion and correlation estimates, as in Liang and Zeger. This can be useful when the number
of observations is small, as subtracting p may yield correlations greater than 1.}

\item{maxit}{maximum number of iterations.}

\item{tol}{tolerance in calculation of coefficients.}

\item{restriction}{either a contrast matrix or a list of a contrast matrix and a right hand side vector, defining a restriction on the regression coefficients. See details.}

\item{conv.criterion}{convergence criterion, either \code{"ratio"} or \code{"difference"}. The default is \code{"ratio"}, using the relative change in regression coefficient
estimates as convergence criterion, like in \code{geem}.
With \code{"difference"} the maximum absolute difference in regression coefficient estimates is used. The latter is required if some coefficient is 0,
e.g. by estimation under some restriction.}
}
\value{
A list with class \code{geem2}, similar to the output
	of \code{geem} from the geeM package. The additional slot \code{sandwich.args} contains components to calculate the sandwich variance estimator for the
fitted model and across models if
applied in the multiple marginal model framework.
}
\description{
\code{geem2} is a modified version of \code{\link[geeM]{geem}} to fit generalized estimating equation models and to provide objects that can be used
for simultaneous inference across multiple marginal models using \code{\link{mmmgee}} and \code{\link{mmmgee.test}}.
Like \code{geem}, \code{geem2} estimates coefficients and nuisance parameters using generalized estimating equations. The link and variance functions can be
specified by the user and the syntax is similar to \code{\link[stats]{glm}}.
}
\details{
The function is a modification of \code{\link[geeM]{geem}} from the geeM package, such that
	additional output is returned that is required for the calculation of covariance
	matrix across multiple marginal models. In particular the contributions of each subject to the estimating equation are made available in the output.

In \code{geem2}, the square root of the weight of an observation is defined as multiplier of the standard error of that observation in the calculation of the 
estimating equation. Note that in contrast in the current version of \code{geem} (version 0.10.0) the diagonal matrix of weights is
used as multiplier of the working correlation matrix. In case that the weights for all observations in one cluster are identical, both definitions are identical and can be 
understood as weighing the cluster-wise contributions to the estimating equation.

\code{geem2} allows for estimation of regression coefficients under linear restrictions \eqn{C\beta=r}, where \code{C} is a contrast matrix, \eqn{\beta}
the vector of regression coefficients and \code{r} a real values right hand side vector. Using the argument \code{restriction}, \code{C} and \code{r} can be specified.
If only \code{C} is specified, \code{r} is assumed as null vector. The functionality is in particular required to calculate the generalized score test for linear hypotheses about
\eqn{\beta}. Use \code{conv.criterion="difference"} if any regression coefficient is restricted to 0.
}
\note{
The option to fit a model with restrictions concerning the coefficients is implemented to enable the calculation of a generalized score test.
It may also be used to obtain estimates of the coefficients under restrictions, but note that currently the calculation of the covariance matrix is not adapted and the 
covariance matrix and standard errors in the output are not valid estimates of the actual quantities.
(The underlying series expansion is incorrect in the restricted model as the score vector is in general not zero at the location of
the restricted parameter estimates.)
}
\examples{
data(lesions)
m1<-geem2(clearance~trt,id=id,data=lesions,family=binomial,corstr="independence")
summary(m1)
m2<-geem2(pain~trt,id=id,data=lesions[lesions$lesion==1,],family=gaussian,corstr="independence")
summary(m2)
geem2(pain~trt,id=id,data=lesions[lesions$lesion==1,],family=gaussian,corstr="exchangeable")


}
\references{
Lee S. McDaniel, Nicholas C. Henderson, Paul J. Rathouz. Fast pure R implementation of GEE: application of the matrix package. The R journal 5.1 (2013): 181.
}
\seealso{
\code{\link{mmmgee}}, \code{\link[geeM]{geem}}, \code{\link{mmmgee.test}}
}
\author{
The \code{geem} function was written by Lee McDaniel and Nick Henderson, modifications for \code{geem2} are by Robin Ristl \email{robin.ristl@meduniwien.ac.at}
}
