% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{std_start}
\alias{std_start}
\title{Standard Starting Value}
\usage{
std_start(cov_type, n_visits, n_groups, ...)
}
\arguments{
\item{cov_type}{(\code{string})\cr name of the covariance structure.}

\item{n_visits}{(\code{int})\cr number of visits.}

\item{n_groups}{(\code{int})\cr number of groups.}

\item{...}{not used.}
}
\value{
A numeric vector of starting values.
}
\description{
Obtain standard start values.
}
\details{
\code{std_start} will try to provide variance parameter from identity matrix.
However, for \code{ar1} and \code{ar1h} the corresponding values are not ideal because the
\eqn{\rho} is usually a positive number thus using 0 as starting value can lead to
incorrect optimization result, and we use 0.5 as the initial value of \eqn{\rho}.
}
