% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objfun.R
\name{objfun}
\alias{objfun}
\alias{objfun.survreg}
\alias{objfun.lm}
\alias{objfun.glm}
\title{Objective function}
\usage{
objfun(x, newdata = NULL, ...)

\method{objfun}{survreg}(x, newdata = NULL, weights = NULL, ...)

\method{objfun}{lm}(x, newdata = NULL, weights = NULL, ...)

\method{objfun}{glm}(x, newdata = NULL, weights = NULL, log = TRUE, ...)
}
\arguments{
\item{x}{model object.}

\item{newdata}{optional. New data frame. Can be useful for model evaluation / benchmarking.}

\item{...}{further arguments passed on to \code{objfun} methods.}

\item{weights}{optional. Prior weights. See \code{\link[stats]{glm}} or \code{\link[stats]{lm}}.}

\item{log}{should the log-Likelihood contributions or the Likelhood contributions be returned?}
}
\value{
vector of objective function contributions.
}
\description{
Get the contributions of an objective function. For \code{\link[stats]{glm}}
these are the (weighted) log-likelihood contributions, for \code{\link[stats]{lm}} the
negative (weighted) squared error.
}
\examples{
## Example taken from ?stats::glm
## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12) 
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm(counts ~ outcome + treatment, family = poisson())
logLik_contributions <- objfun(glm.D93)
sum(logLik_contributions)
logLik(glm.D93)

if(require("survival")) {
  x <- survreg(Surv(futime, fustat) ~ rx, ovarian, dist = "weibull")
  newdata <- ovarian[3:5, ]

  sum(objfun(x))
  x$loglik

  objfun(x, newdata = newdata)
}

}
