% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_means.frequentist.R
\name{estimate_means.lm}
\alias{estimate_means.lm}
\title{Estimate marginal means}
\usage{
\method{estimate_means}{lm}(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "response",
  length = 10,
  ci = 0.95,
  ...
)
}
\arguments{
\item{model}{A Bayesian model.}

\item{levels}{A character vector or formula specifying the names of the predictors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be "fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable along which the means or the contrasts will be estimated. Adjust its length using \code{length}.}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{length}{Length of the spread numeric variables.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of estimated marginal means.
}
\description{
Estimate marginal means
}
\examples{
library(modelbased)

model <- lm(Petal.Length ~ Sepal.Width + Species, data = iris)
estimate_means(model)
estimate_means(model, modulate = "Sepal.Width")
\donttest{
library(lme4)

data <- iris
data$Petal.Length_factor <- ifelse(data$Petal.Length < 4.2, "A", "B")

model <- lmer(Petal.Length ~ Sepal.Width + Species + (1 | Petal.Length_factor), data = data)
estimate_means(model)
estimate_means(model, modulate = "Sepal.Width")
}

}
