% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_nonlinear.R
\name{describe_nonlinear}
\alias{describe_nonlinear}
\alias{describe_nonlinear.data.frame}
\alias{estimate_smooth}
\title{Describe the smooth term (for GAMs) or non-linear predictors}
\usage{
describe_nonlinear(data, ...)

\method{describe_nonlinear}{data.frame}(data, x = NULL, y = NULL, ...)

estimate_smooth(data, ...)
}
\arguments{
\item{data}{The data containing the link, as for instance obtained by
\code{\link[=estimate_relation]{estimate_relation()}}.}

\item{...}{Other arguments to be passed to or from.}

\item{x, y}{The name of the responses variable (\code{y}) predicting variable
(\code{x}).}
}
\value{
A data frame of linear description of non-linear terms.
}
\description{
This function summarises the smooth term trend in terms of linear segments.
Using the approximate derivative, it separates a non-linear vector into
quasi-linear segments (in which the trend is either positive or negative).
Each of this segment its characterized by its beginning, end, size (in
proportion, relative to the total size) trend (the linear regression
coefficient) and linearity (the R2 of the linear regression).
}
\examples{
\dontshow{if (insight::check_if_installed("performance", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create data
data <- data.frame(x = rnorm(200))
data$y <- data$x^2 + rnorm(200, 0, 0.5)

model <<- lm(y ~ poly(x, 2), data = data)
link_data <- estimate_relation(model, length = 100)

describe_nonlinear(link_data, x = "x")
\dontshow{\}) # examplesIf}
}
