% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_score.R
\name{calculate_interaction_score}
\alias{calculate_interaction_score}
\title{Calls a python script to calculate interaction score for combined graphs}
\usage{
calculate_interaction_score(
  max_path_length,
  total_edges,
  loading_path,
  python_executable = "python3",
  script_path = NULL,
  int_score_mode = "auto"
)
}
\arguments{
\item{max_path_length}{The maximum length of simple paths to consider when computing the
interaction score}

\item{total_edges}{vector with total edges in each group}

\item{loading_path}{Directory to use for writing intermediate data when passing input and
output between Python and R}

\item{python_executable}{Python command or path to Python executable to use}

\item{script_path}{Path to the interaction score Python script. Set NULL to use package
internal script (default).}

\item{int_score_mode}{One of `auto`, `sequential` or `ray`. Whether to compute interaction
score in parallel using the Ray python library or sequentially. When `auto` it depends on the
graph sizes.}
}
\value{
Does not return anything, instead calls Python script which outputs .gml files
}
\description{
(INTERNAL) The interaction score is computed and replaces the edge weight.
This function expects the combined graphs for both groups along with their corresponding drug
target and node lists to be
present at `loading_path`. Graphs and drug targets should be weighted edge lists in tsv format.
 Node files should contain one node id per line.
The script for calculating the interaction score is called with `python_executable`. An
alternate script can be specified with `script_path`.
The score for an edge is computed as the sum of the average product of weights along all simple
 paths of length l (over all path lengths
up to `max_path_length`) between the source and target node of the edge.
}
